/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.containers;

import java.net.URI;
import java.time.Duration;
import java.util.UUID;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CamundaContainer
extends GenericContainer<CamundaContainer> {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_READINESS_TIMEOUT = Duration.ofSeconds(10L);
    private static final String READY_ENDPOINT = "/actuator/health/status";
    private static final String TOPOLOGY_ENDPOINT = "/v2/topology";
    private static final String ACTIVE_SPRING_PROFILES = "broker,consolidated-auth";
    private static final String LOG_APPENDER_STACKDRIVER = "Stackdriver";
    private static final String CAMUNDA_EXPORTER_CLASSNAME = "io.camunda.exporter.CamundaExporter";
    private static final String CAMUNDA_EXPORTER_BULK_SIZE = "1";

    public CamundaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.applyDefaultConfiguration();
    }

    private void applyDefaultConfiguration() {
        ((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)this.withNetwork(Network.SHARED)).waitingFor((WaitStrategy)this.newDefaultWaitStrategy())).withEnv("SPRING_PROFILES_ACTIVE", ACTIVE_SPRING_PROFILES)).withEnv("ZEEBE_CLOCK_CONTROLLED", "true")).withEnv("ZEEBE_LOG_APPENDER", LOG_APPENDER_STACKDRIVER)).withH2().addExposedPorts(new int[]{26500, 26501, 26502, 9600, 8080});
    }

    public CamundaContainer withH2() {
        ((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)this.withEnv("CAMUNDA_DATABASE_TYPE", "rdbms")).withEnv("CAMUNDA_DATABASE_URL", H2Configuration.databaseUrL(UUID.randomUUID()))).withEnv("CAMUNDA_DATABASE_USERNAME", "sa")).withEnv("CAMUNDA_DATABASE_PASSWORD", "")).withEnv("ZEEBE_BROKER_EXPORTERS_RDBMS_CLASSNAME", "io.camunda.exporter.rdbms.RdbmsExporter")).withEnv("ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_FLUSH_INTERVAL", "PT0S")).withEnv("ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_DEFAULT_HISTORY_TTL", "PT2S")).withEnv("ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_MIN_HISTORY_CLEANUP_INTERVAL", "PT2S")).withEnv("ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_MAX_HISTORY_CLEANUP_INTERVAL", "PT5S")).withEnv("LOGGING_LEVEL_IO_CAMUNDA_DB_RDBMS", "DEBUG")).withEnv("LOGGING_LEVEL_ORG_MYBATIS", "DEBUG");
        return this;
    }

    public CamundaContainer withElasticsearchUrl(String url) {
        this.withEnv("ZEEBE_BROKER_EXPORTERS_CAMUNDAEXPORTER_CLASSNAME", CAMUNDA_EXPORTER_CLASSNAME);
        this.withEnv("ZEEBE_BROKER_EXPORTERS_CAMUNDAEXPORTER_ARGS_CONNECT_URL", url);
        this.withEnv("ZEEBE_BROKER_EXPORTERS_CAMUNDAEXPORTER_ARGS_BULK_SIZE", CAMUNDA_EXPORTER_BULK_SIZE);
        this.withEnv("CAMUNDA_OPERATE_ELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_OPERATE_ZEEBEELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_TASKLIST_ELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_TASKLIST_ZEEBEELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_DATABASE_URL", url);
        return this;
    }

    public static HttpWaitStrategy newDefaultBrokerReadyCheck() {
        return new HttpWaitStrategy().forPath(READY_ENDPOINT).forPort(9600).forStatusCodeMatching(status -> status >= 200 && status < 300).withReadTimeout(DEFAULT_READINESS_TIMEOUT);
    }

    public static HttpWaitStrategy newDefaultTopologyReadyCheck() {
        return new HttpWaitStrategy().forPath(TOPOLOGY_ENDPOINT).forPort(8080).forStatusCodeMatching(status -> status >= 200 && status < 300).forResponsePredicate(CamundaContainer::isPartitionReady).withReadTimeout(DEFAULT_READINESS_TIMEOUT);
    }

    private static boolean isPartitionReady(String response) {
        return response.matches(".*\"partitionId\"\\s*:\\s*1.*") && response.matches(".*\"role\"\\s*:\\s*\"leader\".*") && response.matches(".*\"health\"\\s*:\\s*\"healthy\".*");
    }

    private WaitAllStrategy newDefaultWaitStrategy() {
        return new WaitAllStrategy(WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)CamundaContainer.newDefaultBrokerReadyCheck()).withStrategy((WaitStrategy)CamundaContainer.newDefaultTopologyReadyCheck()).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT);
    }

    public int getGrpcApiPort() {
        return this.getMappedPort(26500);
    }

    public int getRestApiPort() {
        return this.getMappedPort(8080);
    }

    public URI getGrpcApiAddress() {
        return this.toUriWithPort(this.getGrpcApiPort());
    }

    public URI getRestApiAddress() {
        return this.toUriWithPort(this.getRestApiPort());
    }

    private URI toUriWithPort(int port) {
        return URI.create("http://" + this.getHost() + ":" + port);
    }

    public URI getMonitoringApiAddress() {
        return this.toUriWithPort(this.getMonitoringApiPort());
    }

    public int getMonitoringApiPort() {
        return this.getMappedPort(9600);
    }

    public static class H2Configuration {
        public static final String DATABASE_TYPE = "rdbms";
        public static final String DATABASE_USERNAME = "sa";
        public static final String DATABASE_PASSWORD = "";
        public static final String ZEEBE_BROKER_EXPORTERS_RDBMS_CLASSNAME = "io.camunda.exporter.rdbms.RdbmsExporter";
        public static final String ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_FLUSH_INTERVAL = "PT0S";
        public static final String ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_DEFAULT_HISTORY_TTL = "PT2S";
        public static final String ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_MIN_HISTORY_CLEANUP_INTERVAL = "PT2S";
        public static final String ZEEBE_BROKER_EXPORTERS_RDBMS_ARGS_MAX_HISTORY_CLEANUP_INTERVAL = "PT5S";
        public static final String LOGGING_LEVEL_IO_CAMUNDA_DB_RDBMS = "DEBUG";
        public static final String LOGGING_LEVEL_ORG_MYBATIS = "DEBUG";

        public static String databaseUrL(UUID uuid) {
            return "jdbc:h2:mem:cpt+" + uuid + ";DB_CLOSE_DELAY=-1;MODE=PostgreSQL";
        }
    }
}

