/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.containers;

import java.net.URI;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class ConnectorsContainer
extends GenericContainer<ConnectorsContainer> {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);
    private static final String CONNECTORS_READY_ENDPOINT = "/actuator/health/readiness";
    private static final String LOG_APPENDER_STACKDRIVER = "stackdriver";

    public ConnectorsContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.applyDefaultConfiguration();
    }

    private void applyDefaultConfiguration() {
        ((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)this.withNetwork(Network.SHARED)).waitingFor((WaitStrategy)this.newDefaultWaitStrategy())).withEnv("management.endpoints.web.exposure.include", "health")).withEnv("management.endpoint.health.probes.enabled", "true")).withEnv("CONNECTORS_LOG_APPENDER", LOG_APPENDER_STACKDRIVER)).addExposedPorts(new int[]{8080});
    }

    public ConnectorsContainer withZeebeGrpcApi(String zeebeGrpcApi) {
        this.withEnv("CAMUNDA_CLIENT_GRPC-ADDRESS", zeebeGrpcApi);
        return this;
    }

    public ConnectorsContainer withOperateApi(String operateRestApi) {
        this.withEnv("CAMUNDA_CLIENT_REST-ADDRESS", operateRestApi);
        return this;
    }

    public static HttpWaitStrategy newDefaultConnectorsReadyCheck() {
        return new HttpWaitStrategy().forPath(CONNECTORS_READY_ENDPOINT).forPort(8080).forStatusCodeMatching(status -> status >= 200 && status < 300).withReadTimeout(Duration.ofSeconds(10L));
    }

    private WaitAllStrategy newDefaultWaitStrategy() {
        return new WaitAllStrategy(WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)ConnectorsContainer.newDefaultConnectorsReadyCheck()).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT);
    }

    public int getRestApiPort() {
        return this.getMappedPort(8080);
    }

    public URI getRestApiAddress() {
        return URI.create("http://" + this.getHost() + ":" + this.getRestApiPort());
    }
}

