/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.extension;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.response.ActivateJobsResponse;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.api.assertions.UserTaskSelector;
import io.camunda.process.test.api.assertions.UserTaskSelectors;
import io.camunda.process.test.api.mock.JobWorkerMock;
import io.camunda.process.test.impl.client.CamundaManagementClient;
import io.camunda.process.test.impl.mock.JobWorkerMockImpl;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.awaitility.Awaitility;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.Definitions;
import org.camunda.bpm.model.dmn.instance.LiteralExpression;
import org.camunda.bpm.model.dmn.instance.Text;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaProcessTestContextImpl
implements CamundaProcessTestContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaProcessTestContextImpl.class);
    private static final int TIMEOUT = 40;
    private final URI camundaRestApiAddress;
    private final URI camundaGrpcApiAddress;
    private final URI connectorsRestApiAddress;
    private final CamundaClientBuilderFactory camundaClientBuilderFactory;
    private final Consumer<AutoCloseable> clientCreationCallback;
    private final CamundaManagementClient camundaManagementClient;

    public CamundaProcessTestContextImpl(CamundaProcessTestRuntime camundaRuntime, Consumer<AutoCloseable> clientCreationCallback, CamundaManagementClient camundaManagementClient) {
        this.camundaClientBuilderFactory = camundaRuntime.getCamundaClientBuilderFactory();
        this.camundaRestApiAddress = camundaRuntime.getCamundaRestApiAddress();
        this.camundaGrpcApiAddress = camundaRuntime.getCamundaGrpcApiAddress();
        this.connectorsRestApiAddress = camundaRuntime.getConnectorsRestApiAddress();
        this.clientCreationCallback = clientCreationCallback;
        this.camundaManagementClient = camundaManagementClient;
    }

    @Override
    public CamundaClient createClient() {
        return this.createClient(builder -> {});
    }

    @Override
    public CamundaClient createClient(Consumer<CamundaClientBuilder> modifier) {
        CamundaClientBuilder builder = (CamundaClientBuilder)this.camundaClientBuilderFactory.get();
        modifier.accept(builder);
        CamundaClient client = builder.build();
        this.clientCreationCallback.accept((AutoCloseable)client);
        return client;
    }

    @Override
    public ZeebeClient createZeebeClient() {
        return this.createZeebeClient(builder -> {});
    }

    @Override
    public ZeebeClient createZeebeClient(Consumer<ZeebeClientBuilder> modifier) {
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().usePlaintext().grpcAddress(this.getCamundaGrpcAddress()).restAddress(this.getCamundaRestAddress());
        modifier.accept(builder);
        ZeebeClient client = builder.build();
        this.clientCreationCallback.accept((AutoCloseable)client);
        return client;
    }

    @Override
    public URI getCamundaGrpcAddress() {
        return this.camundaGrpcApiAddress;
    }

    @Override
    public URI getCamundaRestAddress() {
        return this.camundaRestApiAddress;
    }

    @Override
    public URI getConnectorsAddress() {
        return this.connectorsRestApiAddress;
    }

    @Override
    public Instant getCurrentTime() {
        return this.camundaManagementClient.getCurrentTime();
    }

    @Override
    public void increaseTime(Duration timeToAdd) {
        LOGGER.debug("Increase the time by {}", (Object)timeToAdd);
        this.camundaManagementClient.increaseTime(timeToAdd);
    }

    @Override
    public JobWorkerMock mockJobWorker(String jobType) {
        CamundaClient client = this.createClient();
        return new JobWorkerMockImpl(jobType, client);
    }

    @Override
    public void mockChildProcess(String childProcessId) {
        this.mockChildProcess(childProcessId, new HashMap<String, Object>());
    }

    @Override
    public void mockChildProcess(String childProcessId, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        BpmnModelInstance processModel = Bpmn.createExecutableProcess((String)childProcessId).startEvent().endEvent("child-end", e -> variables.forEach((k, v) -> e.zeebeOutput("=" + client.getConfiguration().getJsonMapper().toJson(v), k))).done();
        LOGGER.debug("Mock: Deploy a child process '{}' with result variables {}", (Object)childProcessId, variables);
        String resourceName = childProcessId + ".bpmn";
        client.newDeployResourceCommand().addProcessModel(processModel, resourceName).send().join();
    }

    @Override
    public void completeJob(String jobType) {
        this.completeJob(jobType, new HashMap<String, Object>());
    }

    @Override
    public void completeJob(String jobType, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        ActivatedJob job = this.getActivatedJob(jobType);
        LOGGER.debug("Complete job with variables {} [job-type: '{}', job-key: '{}']", new Object[]{variables, jobType, job.getKey()});
        client.newCompleteCommand(job).variables(variables).send().join();
    }

    @Override
    public void throwBpmnErrorFromJob(String jobType, String errorCode) {
        this.throwBpmnErrorFromJob(jobType, errorCode, new HashMap<String, Object>());
    }

    @Override
    public void throwBpmnErrorFromJob(String jobType, String errorCode, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        ActivatedJob job = this.getActivatedJob(jobType);
        LOGGER.debug("Throw BPMN error with error code {} and variables {} [job-type: '{}', job-key: '{}']", new Object[]{errorCode, variables, jobType, job.getKey()});
        client.newThrowErrorCommand(job).errorCode(errorCode).variables(variables).send().join();
    }

    @Override
    public void completeUserTask(String taskName) {
        this.completeUserTask(UserTaskSelectors.byTaskName(taskName), new HashMap<String, Object>());
    }

    @Override
    public void completeUserTask(String taskName, Map<String, Object> variables) {
        this.completeUserTask(UserTaskSelectors.byTaskName(taskName), variables);
    }

    @Override
    public void completeUserTask(UserTaskSelector userTaskSelector) {
        this.completeUserTask(userTaskSelector, new HashMap<String, Object>());
    }

    @Override
    public void completeUserTask(UserTaskSelector userTaskSelector, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        AtomicReference userTaskKey = new AtomicReference();
        Awaitility.await((String)"until user task is active").ignoreExceptions().atMost(Duration.ofSeconds(80L)).untilAsserted(() -> {
            CamundaFuture userTaskFuture = client.newUserTaskSearchRequest().send();
            Assertions.assertThat((Future)userTaskFuture).succeedsWithin(Duration.ofSeconds(40L)).extracting(SearchResponse::items).satisfies(new ThrowingConsumer[]{items -> {
                List tasks = items.stream().filter(userTaskSelector::test).collect(Collectors.toList());
                Assertions.assertThat(tasks).isNotEmpty();
                userTaskKey.set(((UserTask)items.get(0)).getUserTaskKey());
            }});
        });
        LOGGER.debug("Complete user task with variables {} [user-task-key: '{}']", variables, userTaskKey.get());
        client.newUserTaskCompleteCommand(((Long)userTaskKey.get()).longValue()).variables(variables).send().join();
    }

    @Override
    public void mockDmnDecision(String decisionId, Map<String, Object> variables) {
        CamundaClient client = this.createClient();
        String jsonVariables = client.getConfiguration().getJsonMapper().toJson(variables);
        DmnModelInstance modelInstance = Dmn.createEmptyModel();
        Definitions definitions = (Definitions)modelInstance.newInstance(Definitions.class);
        definitions.setName(decisionId + "-name");
        definitions.setNamespace("http://camunda.org/schema/1.0/dmn");
        modelInstance.setDefinitions(definitions);
        Decision decision = (Decision)modelInstance.newInstance(Decision.class);
        decision.setId(decisionId);
        decision.setName(decisionId + "-decision-name");
        definitions.addChildElement((ModelElementInstance)decision);
        LiteralExpression literalExpression = (LiteralExpression)modelInstance.newInstance(LiteralExpression.class);
        Text text = (Text)modelInstance.newInstance(Text.class);
        text.setTextContent(jsonVariables);
        literalExpression.setText(text);
        decision.addChildElement((ModelElementInstance)literalExpression);
        LOGGER.debug("Mock: Deploy a DMN '{}' with result variables {}", (Object)decisionId, variables);
        String resourceName = decisionId + ".dmn";
        client.newDeployResourceCommand().addResourceStream((InputStream)new ByteArrayInputStream(Dmn.convertToString((DmnModelInstance)modelInstance).getBytes()), resourceName).send().join();
    }

    private ActivatedJob getActivatedJob(String jobType) {
        CamundaClient client = this.createClient();
        AtomicReference activatedJob = new AtomicReference();
        Awaitility.await().atMost(Duration.ofSeconds(10L)).untilAsserted(() -> {
            List jobs = ((ActivateJobsResponse)client.newActivateJobsCommand().jobType(jobType).maxJobsToActivate(1).send().join()).getJobs();
            Assertions.assertThat((List)jobs).isNotEmpty();
            activatedJob.set((ActivatedJob)jobs.get(0));
        });
        return (ActivatedJob)activatedJob.get();
    }
}

