/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.mock;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.worker.JobHandler;
import io.camunda.process.test.api.mock.JobWorkerMock;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerMockImpl
implements JobWorkerMock {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerMockImpl.class);
    private final String jobType;
    private final CamundaClient client;

    public JobWorkerMockImpl(String jobType, CamundaClient client) {
        this.jobType = jobType;
        this.client = client;
    }

    @Override
    public void thenComplete() {
        this.thenComplete(new HashMap<String, Object>());
    }

    @Override
    public void thenComplete(Map<String, Object> variables) {
        this.withHandler((jobClient, job) -> {
            LOGGER.debug("Mock: Complete job with variables {} [job-type: '{}', job-key: '{}']", new Object[]{variables, this.jobType, job.getKey()});
            jobClient.newCompleteCommand(job).variables(variables).send().join();
        });
    }

    @Override
    public void thenThrowBpmnError(String errorCode) {
        this.thenThrowBpmnError(errorCode, new HashMap<String, Object>());
    }

    @Override
    public void thenThrowBpmnError(String errorCode, Map<String, Object> variables) {
        this.withHandler((jobClient, job) -> {
            LOGGER.debug("Mock: Throw BPMN error with error code {} and variables {} [job-type: '{}', job-key: '{}']", new Object[]{errorCode, variables, this.jobType, job.getKey()});
            jobClient.newThrowErrorCommand(job).errorCode(errorCode).variables(variables).send().join();
        });
    }

    @Override
    public void withHandler(JobHandler jobHandler) {
        JobHandler loggingJobHandler = (client, job) -> {
            LOGGER.debug("Mock: Pass job to custom handler [job-type: '{}', job-key: '{}']", (Object)this.jobType, (Object)job.getKey());
            jobHandler.handle(client, job);
        };
        this.client.newWorker().jobType(this.jobType).handler(loggingJobHandler).open();
    }
}

