/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.api.response.PartitionBrokerHealth;
import io.camunda.client.api.response.PartitionInfo;
import io.camunda.client.api.response.Topology;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import java.net.URI;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaProcessTestRemoteRuntime
implements CamundaProcessTestRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaProcessTestRemoteRuntime.class);
    private final URI camundaRestApiAddress;
    private final URI camundaGrpcApiAddress;
    private final URI camundaMonitoringApiAddress;
    private final URI connectorsRestApiAddress;
    private final CamundaClientBuilderFactory camundaClientBuilderFactory;

    public CamundaProcessTestRemoteRuntime(CamundaProcessTestRuntimeBuilder runtimeBuilder) {
        this.camundaClientBuilderFactory = runtimeBuilder.getRemoteCamundaClientBuilderFactory();
        this.camundaMonitoringApiAddress = runtimeBuilder.getRemoteCamundaMonitoringApiAddress();
        this.connectorsRestApiAddress = runtimeBuilder.getRemoteConnectorsRestApiAddress();
        CamundaClientConfiguration clientConfiguration = this.getClientConfiguration(this.camundaClientBuilderFactory);
        this.camundaRestApiAddress = clientConfiguration.getRestAddress();
        this.camundaGrpcApiAddress = clientConfiguration.getGrpcAddress();
    }

    @Override
    public void start() {
        LOGGER.info("Connecting to remote runtime. [Camunda REST: {}, Camunda gRPC: {}, Camunda Monitoring: {}, Connectors REST: {}]", new Object[]{this.camundaRestApiAddress, this.camundaGrpcApiAddress, this.camundaMonitoringApiAddress, this.connectorsRestApiAddress});
        this.checkConnectionToRemoteRuntime();
    }

    @Override
    public URI getCamundaRestApiAddress() {
        return this.camundaRestApiAddress;
    }

    @Override
    public URI getCamundaGrpcApiAddress() {
        return this.camundaGrpcApiAddress;
    }

    @Override
    public URI getCamundaMonitoringApiAddress() {
        return this.camundaMonitoringApiAddress;
    }

    @Override
    public URI getConnectorsRestApiAddress() {
        return this.connectorsRestApiAddress;
    }

    @Override
    public CamundaClientBuilderFactory getCamundaClientBuilderFactory() {
        return this.camundaClientBuilderFactory;
    }

    private void checkConnectionToRemoteRuntime() {
        try (CamundaClient camundaClient = ((CamundaClientBuilder)this.getCamundaClientBuilderFactory().get()).build();){
            Topology topology = (Topology)camundaClient.newTopologyRequest().send().join();
            boolean isHealthy = topology.getBrokers().stream().flatMap(brokerInfo -> brokerInfo.getPartitions().stream()).map(PartitionInfo::getHealth).allMatch(arg_0 -> PartitionBrokerHealth.HEALTHY.equals(arg_0));
            if (isHealthy) {
                LOGGER.info("Remote Camunda runtime connected. [version: {}]", (Object)topology.getGatewayVersion());
            } else {
                LOGGER.warn("Remote Camunda runtime is unhealthy. [topology: {}]", (Object)topology);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to remote Camunda runtime.", e);
        }
    }

    private CamundaClientConfiguration getClientConfiguration(Supplier<CamundaClientBuilder> camundaClientBuilderSupplier) {
        CamundaClientBuilder clientBuilder = camundaClientBuilderSupplier.get();
        try (CamundaClient camundaClient = clientBuilder.build();){
            CamundaClientConfiguration camundaClientConfiguration = camundaClient.getConfiguration();
            return camundaClientConfiguration;
        }
    }

    @Override
    public void close() throws Exception {
    }
}

