/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerRuntimePropertiesUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ContainerRuntimePropertiesUtil.class);
    public static final String RUNTIME_PROPERTIES_FILE = "/camunda-container-runtime.properties";
    public static final String PROPERTY_NAME_CAMUNDA_VERSION = "camunda.version";
    public static final String PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_NAME = "camunda.dockerImageName";
    public static final String PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_VERSION = "camunda.dockerImageVersion";
    public static final String PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_NAME = "connectors.dockerImageName";
    public static final String PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_VERSION = "connectors.dockerImageVersion";
    public static final String PROPERTY_NAME_ELASTICSEARCH_VERSION = "elasticsearch.version";
    public static final String SNAPSHOT_VERSION = "SNAPSHOT";
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-.*)?");
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{.*}");
    private static final String VERSION_FORMAT = "%d.%d.%d";
    private static final String LABELED_VERSION_FORMAT = "%d.%d.%d%s";
    private final String camundaVersion;
    private final String camundaDockerImageName;
    private final String camundaDockerImageVersion;
    private final String connectorsDockerImageName;
    private final String connectorsDockerImageVersion;
    private final String elasticsearchVersion;

    public ContainerRuntimePropertiesUtil(Properties properties) {
        this.camundaVersion = ContainerRuntimePropertiesUtil.getLatestReleasedVersion(properties, PROPERTY_NAME_CAMUNDA_VERSION, SNAPSHOT_VERSION);
        this.elasticsearchVersion = ContainerRuntimePropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_ELASTICSEARCH_VERSION, "8.13.0");
        this.camundaDockerImageName = ContainerRuntimePropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_NAME, "camunda/camunda");
        this.camundaDockerImageVersion = ContainerRuntimePropertiesUtil.getLatestReleasedVersion(properties, PROPERTY_NAME_CAMUNDA_DOCKER_IMAGE_VERSION, SNAPSHOT_VERSION);
        this.connectorsDockerImageName = ContainerRuntimePropertiesUtil.getPropertyOrDefault(properties, PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_NAME, "camunda/connectors-bundle");
        this.connectorsDockerImageVersion = ContainerRuntimePropertiesUtil.getLatestReleasedVersion(properties, PROPERTY_NAME_CONNECTORS_DOCKER_IMAGE_VERSION, SNAPSHOT_VERSION);
    }

    private static String getLatestReleasedVersion(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null || ContainerRuntimePropertiesUtil.isPlaceholder(propertyValue)) {
            return defaultValue;
        }
        return Optional.of(propertyValue).map(SEMANTIC_VERSION_PATTERN::matcher).filter(Matcher::find).map(matcher -> {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            String label = matcher.group(4);
            return ContainerRuntimePropertiesUtil.getLatestReleasedVersion(major, minor, patch, label);
        }).orElse(propertyValue);
    }

    private static boolean isPlaceholder(String propertyValue) {
        return PLACEHOLDER_PATTERN.matcher(propertyValue).matches();
    }

    private static String getLatestReleasedVersion(int major, int minor, int patch, String label) {
        if (label == null) {
            return String.format(VERSION_FORMAT, major, minor, patch);
        }
        if (!label.contains(SNAPSHOT_VERSION)) {
            return String.format(LABELED_VERSION_FORMAT, major, minor, patch, label);
        }
        if (patch == 0) {
            return SNAPSHOT_VERSION;
        }
        int previousPatchVersion = patch - 1;
        return String.format(VERSION_FORMAT, major, minor, previousPatchVersion);
    }

    private static String getPropertyOrDefault(Properties versionProperties, String propertyName, String defaultValue) {
        String propertyValue = versionProperties.getProperty(propertyName);
        if (propertyValue == null || ContainerRuntimePropertiesUtil.isPlaceholder(propertyValue)) {
            return defaultValue;
        }
        return propertyValue;
    }

    public static ContainerRuntimePropertiesUtil readProperties() {
        return new ContainerRuntimePropertiesUtil(ContainerRuntimePropertiesUtil.readPropertiesFile());
    }

    private static Properties readPropertiesFile() {
        Properties properties;
        block8: {
            InputStream propertiesFileStream = ContainerRuntimePropertiesUtil.class.getResourceAsStream(RUNTIME_PROPERTIES_FILE);
            try {
                Properties properties2 = new Properties();
                properties2.load(propertiesFileStream);
                properties = properties2;
                if (propertiesFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesFileStream != null) {
                        try {
                            propertiesFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Can't read properties file: {}", (Object)RUNTIME_PROPERTIES_FILE, (Object)e);
                    return new Properties();
                }
            }
            propertiesFileStream.close();
        }
        return properties;
    }

    public String getCamundaVersion() {
        return this.camundaVersion;
    }

    public String getElasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public String getCamundaDockerImageName() {
        return this.camundaDockerImageName;
    }

    public String getCamundaDockerImageVersion() {
        return this.camundaDockerImageVersion;
    }

    public String getConnectorsDockerImageName() {
        return this.connectorsDockerImageName;
    }

    public String getConnectorsDockerImageVersion() {
        return this.connectorsDockerImageVersion;
    }
}

