/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.JsonMapper;
import io.camunda.process.test.api.CamundaAssert;
import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.client.CamundaManagementClient;
import io.camunda.process.test.impl.configuration.CamundaProcessTestRuntimeConfiguration;
import io.camunda.process.test.impl.extension.CamundaProcessTestContextImpl;
import io.camunda.process.test.impl.proxy.CamundaClientProxy;
import io.camunda.process.test.impl.proxy.CamundaProcessTestContextProxy;
import io.camunda.process.test.impl.proxy.ZeebeClientProxy;
import io.camunda.process.test.impl.runtime.CamundaProcessTestContainerRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import io.camunda.process.test.impl.runtime.CamundaSpringProcessTestRuntimeBuilder;
import io.camunda.process.test.impl.testresult.CamundaProcessTestResultCollector;
import io.camunda.process.test.impl.testresult.CamundaProcessTestResultPrinter;
import io.camunda.process.test.impl.testresult.ProcessTestResult;
import io.camunda.spring.client.event.CamundaClientClosingEvent;
import io.camunda.spring.client.event.CamundaClientCreatedEvent;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.event.ZeebeClientClosingEvent;
import io.camunda.zeebe.spring.client.event.ZeebeClientCreatedEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.Ordered;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

public class CamundaProcessTestExecutionListener
implements TestExecutionListener,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaProcessTestExecutionListener.class);
    private final CamundaProcessTestRuntimeBuilder containerRuntimeBuilder;
    private final CamundaProcessTestResultPrinter processTestResultPrinter;
    private final List<AutoCloseable> createdClients = new ArrayList<AutoCloseable>();
    private CamundaProcessTestRuntime runtime;
    private CamundaProcessTestResultCollector processTestResultCollector;
    private CamundaProcessTestContext camundaProcessTestContext;
    private CamundaManagementClient camundaManagementClient;
    private CamundaClient client;
    private ZeebeClient zeebeClient;

    public CamundaProcessTestExecutionListener() {
        this(CamundaProcessTestContainerRuntime.newBuilder(), System.err::println);
    }

    CamundaProcessTestExecutionListener(CamundaProcessTestRuntimeBuilder containerRuntimeBuilder, Consumer<String> testResultPrintStream) {
        this.containerRuntimeBuilder = containerRuntimeBuilder;
        this.processTestResultPrinter = new CamundaProcessTestResultPrinter(testResultPrintStream);
    }

    public void beforeTestClass(TestContext testContext) {
        this.runtime = this.buildRuntime(testContext);
        this.runtime.start();
        this.camundaManagementClient = new CamundaManagementClient(this.runtime.getCamundaMonitoringApiAddress(), this.runtime.getCamundaRestApiAddress());
        this.camundaProcessTestContext = new CamundaProcessTestContextImpl(this.runtime, this.createdClients::add, this.camundaManagementClient);
    }

    public void beforeTestMethod(TestContext testContext) {
        this.client = CamundaProcessTestExecutionListener.createClient(testContext, this.camundaProcessTestContext);
        this.zeebeClient = CamundaProcessTestExecutionListener.createZeebeClient(testContext, this.camundaProcessTestContext);
        ((CamundaClientProxy)testContext.getApplicationContext().getBean(CamundaClientProxy.class)).setClient(this.client);
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).setClient(this.zeebeClient);
        ((CamundaProcessTestContextProxy)testContext.getApplicationContext().getBean(CamundaProcessTestContextProxy.class)).setContext(this.camundaProcessTestContext);
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new CamundaClientCreatedEvent((Object)this, this.client));
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new ZeebeClientCreatedEvent((Object)this, this.zeebeClient));
        CamundaDataSource dataSource = new CamundaDataSource(this.client);
        CamundaAssert.initialize((CamundaDataSource)dataSource);
        this.processTestResultCollector = new CamundaProcessTestResultCollector(dataSource);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        if (this.runtime == null) {
            return;
        }
        if (CamundaProcessTestExecutionListener.isTestFailed(testContext)) {
            this.printTestResults();
        }
        CamundaAssert.reset();
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new CamundaClientClosingEvent((Object)this, this.client));
        testContext.getApplicationContext().publishEvent((ApplicationEvent)new ZeebeClientClosingEvent((Object)this, this.zeebeClient));
        this.closeCreatedClients();
        ((CamundaClientProxy)testContext.getApplicationContext().getBean(CamundaClientProxy.class)).removeClient();
        ((ZeebeClientProxy)testContext.getApplicationContext().getBean(ZeebeClientProxy.class)).removeClient();
        ((CamundaProcessTestContextProxy)testContext.getApplicationContext().getBean(CamundaProcessTestContextProxy.class)).removeContext();
        this.resetRuntimeClock();
        this.deleteRuntimeData();
    }

    public void afterTestClass(TestContext testContext) throws Exception {
        if (this.runtime == null) {
            return;
        }
        this.runtime.close();
    }

    private void printTestResults() {
        try {
            ProcessTestResult testResult = this.processTestResultCollector.collect();
            this.processTestResultPrinter.print(testResult);
        }
        catch (Throwable t) {
            LOG.warn("Failed to collect test results, skipping.", t);
        }
    }

    private void deleteRuntimeData() {
        try {
            LOG.debug("Deleting the runtime data");
            Instant startTime = Instant.now();
            this.camundaManagementClient.purgeCluster();
            Instant endTime = Instant.now();
            Duration duration = Duration.between(startTime, endTime);
            LOG.debug("Runtime data deleted in {}", (Object)duration);
        }
        catch (Throwable t) {
            LOG.warn("Failed to delete the runtime data, skipping. Check the runtime for details. Note that a dirty runtime may cause failures in other test cases.", t);
        }
    }

    private void resetRuntimeClock() {
        try {
            LOG.info("Resetting the time");
            this.camundaManagementClient.resetTime();
            LOG.info("Time reset");
        }
        catch (Throwable t) {
            LOG.warn("Failed to reset the time, skipping. Check the runtime for details. Note that a dirty runtime may cause failures in other test cases.", t);
        }
    }

    private void closeCreatedClients() {
        for (AutoCloseable client : this.createdClients) {
            try {
                client.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to close client, continue.", (Throwable)e);
            }
        }
    }

    private CamundaProcessTestRuntime buildRuntime(TestContext testContext) {
        CamundaProcessTestRuntimeConfiguration runtimeConfiguration = (CamundaProcessTestRuntimeConfiguration)testContext.getApplicationContext().getBean(CamundaProcessTestRuntimeConfiguration.class);
        return CamundaSpringProcessTestRuntimeBuilder.buildRuntime(this.containerRuntimeBuilder, runtimeConfiguration);
    }

    private static CamundaClient createClient(TestContext testContext, CamundaProcessTestContext camundaProcessTestContext) {
        return camundaProcessTestContext.createClient(builder -> {
            if (CamundaProcessTestExecutionListener.hasBeanForType(testContext, JsonMapper.class)) {
                JsonMapper jsonMapper = (JsonMapper)testContext.getApplicationContext().getBean(JsonMapper.class);
                builder.withJsonMapper(jsonMapper);
            }
        });
    }

    private static ZeebeClient createZeebeClient(TestContext testContext, CamundaProcessTestContext camundaProcessTestContext) {
        return camundaProcessTestContext.createZeebeClient(builder -> {
            if (CamundaProcessTestExecutionListener.hasBeanForType(testContext, io.camunda.zeebe.client.api.JsonMapper.class)) {
                builder.withJsonMapper((io.camunda.zeebe.client.api.JsonMapper)testContext.getApplicationContext().getBean(io.camunda.zeebe.client.api.JsonMapper.class));
            }
        });
    }

    private static boolean hasBeanForType(TestContext testContext, Class<?> type) {
        return testContext.getApplicationContext().getBeanNamesForType(type).length > 0;
    }

    private static boolean isTestFailed(TestContext testContext) {
        return testContext.getTestException() != null;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

