/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CamundaClientCloudBuilderStep1;
import io.camunda.client.CredentialsProvider;
import io.camunda.process.test.api.CamundaClientBuilderFactory;
import io.camunda.process.test.api.CamundaProcessTestRuntimeMode;
import io.camunda.process.test.impl.configuration.CamundaProcessTestRuntimeConfiguration;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntime;
import io.camunda.process.test.impl.runtime.CamundaProcessTestRuntimeBuilder;
import io.camunda.spring.client.configuration.CredentialsProviderConfiguration;
import io.camunda.spring.client.properties.CamundaClientAuthProperties;
import io.camunda.spring.client.properties.CamundaClientCloudProperties;
import io.camunda.spring.client.properties.CamundaClientProperties;

public class CamundaSpringProcessTestRuntimeBuilder {
    public static CamundaProcessTestRuntime buildRuntime(CamundaProcessTestRuntimeBuilder runtimeBuilder, CamundaProcessTestRuntimeConfiguration runtimeConfiguration) {
        CamundaProcessTestRuntimeMode runtimeMode = runtimeConfiguration.getRuntimeMode();
        runtimeBuilder.withRuntimeMode(runtimeMode);
        if (runtimeMode == CamundaProcessTestRuntimeMode.MANAGED || runtimeMode == null) {
            CamundaSpringProcessTestRuntimeBuilder.configureManagedRuntime(runtimeBuilder, runtimeConfiguration);
        } else if (runtimeMode == CamundaProcessTestRuntimeMode.REMOTE) {
            CamundaSpringProcessTestRuntimeBuilder.configureRemoteRuntime(runtimeBuilder, runtimeConfiguration);
        }
        return runtimeBuilder.build();
    }

    private static void configureManagedRuntime(CamundaProcessTestRuntimeBuilder runtimeBuilder, CamundaProcessTestRuntimeConfiguration runtimeConfiguration) {
        runtimeBuilder.withCamundaDockerImageVersion(runtimeConfiguration.getCamundaDockerImageVersion()).withCamundaDockerImageName(runtimeConfiguration.getCamundaDockerImageName()).withCamundaEnv(runtimeConfiguration.getCamundaEnvVars());
        runtimeConfiguration.getCamundaExposedPorts().forEach(arg_0 -> ((CamundaProcessTestRuntimeBuilder)runtimeBuilder).withCamundaExposedPort(arg_0));
        runtimeBuilder.withConnectorsEnabled(runtimeConfiguration.isConnectorsEnabled()).withConnectorsDockerImageName(runtimeConfiguration.getConnectorsDockerImageName()).withConnectorsDockerImageVersion(runtimeConfiguration.getConnectorsDockerImageVersion()).withConnectorsEnv(runtimeConfiguration.getConnectorsEnvVars()).withConnectorsSecrets(runtimeConfiguration.getConnectorsSecrets());
    }

    private static void configureRemoteRuntime(CamundaProcessTestRuntimeBuilder runtimeBuilder, CamundaProcessTestRuntimeConfiguration runtimeConfiguration) {
        runtimeBuilder.withRemoteCamundaMonitoringApiAddress(runtimeConfiguration.getRemote().getCamundaMonitoringApiAddress()).withRemoteConnectorsRestApiAddress(runtimeConfiguration.getRemote().getConnectorsRestApiAddress());
        CamundaClientBuilderFactory remoteClientBuilderFactory = CamundaSpringProcessTestRuntimeBuilder.createRemoteClientBuilderFactory(runtimeConfiguration);
        runtimeBuilder.withRemoteCamundaClientBuilderFactory(remoteClientBuilderFactory);
    }

    private static CamundaClientBuilderFactory createRemoteClientBuilderFactory(CamundaProcessTestRuntimeConfiguration runtimeConfiguration) {
        CamundaClientProperties remoteClientProperties = runtimeConfiguration.getRemote().getClient();
        CamundaClientBuilder clientBuilder = CamundaSpringProcessTestRuntimeBuilder.createCamundaClientBuilder(remoteClientProperties);
        if (remoteClientProperties.getRestAddress() != null) {
            clientBuilder.restAddress(remoteClientProperties.getRestAddress());
        }
        if (remoteClientProperties.getGrpcAddress() != null) {
            clientBuilder.grpcAddress(remoteClientProperties.getGrpcAddress());
        }
        return () -> clientBuilder;
    }

    private static CamundaClientBuilder createCamundaClientBuilder(CamundaClientProperties clientProperties) {
        if (clientProperties.getMode() == CamundaClientProperties.ClientMode.saas) {
            return CamundaSpringProcessTestRuntimeBuilder.createCamundaSaasClientBuilder(clientProperties);
        }
        return CamundaClient.newClientBuilder().usePlaintext();
    }

    private static CamundaClientBuilder createCamundaSaasClientBuilder(CamundaClientProperties clientProperties) {
        CamundaClientCloudProperties cloudProperties = clientProperties.getCloud();
        CamundaClientAuthProperties authProperties = clientProperties.getAuth();
        CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4 cloudBuilderStep = CamundaClient.newCloudClientBuilder().withClusterId(cloudProperties.getClusterId()).withClientId(authProperties.getClientId()).withClientSecret(authProperties.getClientSecret()).withRegion(cloudProperties.getRegion());
        if (authProperties.getMethod() != null) {
            CredentialsProvider credentialsProvider = CamundaSpringProcessTestRuntimeBuilder.createCredentialsProvider(clientProperties);
            cloudBuilderStep.credentialsProvider(credentialsProvider);
        }
        return cloudBuilderStep;
    }

    private static CredentialsProvider createCredentialsProvider(CamundaClientProperties clientProperties) {
        return new CredentialsProviderConfiguration().camundaClientCredentialsProvider(clientProperties);
    }
}

