/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.connect.plugin;

import io.camunda.plugin.search.header.CustomHeader;
import io.camunda.plugin.search.header.DatabaseCustomHeaderSupplier;
import io.camunda.search.connect.plugin.CompatHttpRequestInterceptor;
import io.camunda.search.connect.plugin.PluginConfiguration;
import io.camunda.search.connect.plugin.PluginLoadException;
import io.camunda.search.connect.plugin.PluginRepositoryInterceptor;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.jar.ExternalJarRepository;
import io.camunda.zeebe.util.jar.ThreadContextUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.SequencedMap;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginRepository
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginRepository.class);
    private final ExternalJarRepository jarRepository;
    private final LinkedHashMap<String, Class<? extends DatabaseCustomHeaderSupplier>> plugins;
    private final Path basePath;

    public PluginRepository() {
        this(new LinkedHashMap<String, Class<? extends DatabaseCustomHeaderSupplier>>(), new ExternalJarRepository(), Paths.get(Optional.ofNullable(System.getProperty("basedir")).orElse("."), new String[0]));
    }

    PluginRepository(LinkedHashMap<String, Class<? extends DatabaseCustomHeaderSupplier>> plugins, ExternalJarRepository jarRepository, Path basePath) {
        this.plugins = plugins;
        this.jarRepository = jarRepository;
        this.basePath = basePath;
    }

    SequencedMap<String, Class<? extends DatabaseCustomHeaderSupplier>> getPlugins() {
        return Collections.unmodifiableSequencedMap(this.plugins);
    }

    public boolean isEmpty() {
        return this.plugins.isEmpty();
    }

    public CompatHttpRequestInterceptor asRequestInterceptor() {
        return PluginRepositoryInterceptor.ofRepository(this);
    }

    public PluginRepository load(SequencedCollection<PluginConfiguration> configs) {
        if (configs == null || configs.isEmpty()) {
            return this;
        }
        configs.forEach(config -> {
            try {
                this.load((PluginConfiguration)config);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to load interceptor {} with config {}", (Object)config.id(), config);
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        });
        return this;
    }

    @Override
    public void close() throws Exception {
        try {
            this.jarRepository.close();
        }
        catch (Exception e) {
            LOGGER.warn("Failed to close external JAR repository; may result in dangling file descriptors", (Throwable)e);
        }
    }

    private void load(PluginConfiguration config) throws ExternalJarLoadException {
        Class<DatabaseCustomHeaderSupplier> interceptorClass;
        ClassLoader classLoader;
        String id = config.id();
        if (this.plugins.containsKey(id)) {
            return;
        }
        if (!config.isExternal()) {
            classLoader = this.getClass().getClassLoader();
        } else {
            Path jarPath = this.basePath.resolve(config.jarPath());
            classLoader = this.jarRepository.load(jarPath);
        }
        try {
            Class<?> specifiedClass = classLoader.loadClass(config.className());
            interceptorClass = specifiedClass.asSubclass(DatabaseCustomHeaderSupplier.class);
        }
        catch (ClassNotFoundException e) {
            throw new PluginLoadException(id, "cannot load specified class", e);
        }
        catch (ClassCastException e) {
            throw new PluginLoadException(id, "specified class does not implement " + DatabaseCustomHeaderSupplier.class.getName(), e);
        }
        this.plugins.put(id, interceptorClass);
    }

    Stream<DatabaseCustomHeaderSupplier> instantiatePlugins() {
        return this.plugins.entrySet().stream().map(entry -> this.instantiateSinglePlugin((String)entry.getKey(), (Class)entry.getValue()));
    }

    private DatabaseCustomHeaderSupplier instantiateSinglePlugin(String id, Class<? extends DatabaseCustomHeaderSupplier> interceptorClass) {
        try {
            return this.instrumented((DatabaseCustomHeaderSupplier)ReflectUtil.newInstance(interceptorClass));
        }
        catch (Exception e) {
            throw new PluginLoadException(id, "cannot instantiate via the default constructor", e);
        }
    }

    private DatabaseCustomHeaderSupplier instrumented(DatabaseCustomHeaderSupplier supplier) {
        return () -> (CustomHeader)ThreadContextUtil.supplyWithClassLoader(() -> ((DatabaseCustomHeaderSupplier)supplier).getSearchDatabaseCustomHeader(), (ClassLoader)supplier.getClass().getClassLoader());
    }
}

