/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.search;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.es.transformers.ElasticsearchTransformer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;
import io.camunda.search.es.transformers.search.SearchQueryHitTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class SearchResponseTransformer<T>
extends ElasticsearchTransformer<SearchResponse<T>, SearchQueryResponse<T>> {
    public SearchResponseTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public SearchQueryResponse<T> apply(SearchResponse<T> value) {
        HitsMetadata hits = value.hits();
        String scrollId = value.scrollId();
        TotalHits total = hits.total();
        long totalHits = this.of(total);
        List sourceHits = hits.hits();
        List<SearchQueryHit<T>> transformedHits = this.of(sourceHits);
        return new SearchQueryResponse.Builder().totalHits(totalHits).scrollId(scrollId).hits(transformedHits).build();
    }

    private List<SearchQueryHit<T>> of(List<Hit<T>> hits) {
        if (hits != null) {
            SearchQueryHitTransformer hitTransformer = new SearchQueryHitTransformer(this.transformers);
            return hits.stream().map(hitTransformer::apply).collect(Collectors.toList());
        }
        return new ArrayList<SearchQueryHit<T>>();
    }

    private long of(TotalHits totalHits) {
        if (totalHits != null) {
            return totalHits.value();
        }
        return 0L;
    }
}

