/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.es.transformers.sort;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.SortOptionsBuilders;
import co.elastic.clients.elasticsearch._types.SortOrder;
import io.camunda.search.clients.sort.SearchFieldSort;
import io.camunda.search.es.transformers.ElasticsearchTransformer;
import io.camunda.search.es.transformers.ElasticsearchTransformers;

public final class FieldSortTransformer
extends ElasticsearchTransformer<SearchFieldSort, FieldSort> {
    public FieldSortTransformer(ElasticsearchTransformers transformers) {
        super(transformers);
    }

    public FieldSort apply(SearchFieldSort value) {
        String field = value.field();
        SortOrder order = this.toSortOrder(value);
        String missing = value.missing();
        FieldSort.Builder builder = SortOptionsBuilders.field().field(field).order(order);
        return missing == null ? builder.build() : builder.missing(FieldValue.of((String)missing)).build();
    }

    private SortOrder toSortOrder(SearchFieldSort value) {
        if (value != null) {
            if (value.asc()) {
                return SortOrder.Asc;
            }
            if (value.desc()) {
                return SortOrder.Desc;
            }
        }
        return null;
    }
}

