/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.clients;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.search.os.transformers.OpensearchTransformers;
import io.camunda.search.os.transformers.search.SearchResponseTransformer;
import io.camunda.search.transformers.SearchTransfomer;
import io.camunda.zeebe.util.Either;
import java.io.IOException;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.transport.OpenSearchTransport;

public final class OpensearchSearchClient
implements CamundaSearchClient {
    private final OpenSearchClient client;
    private final OpensearchTransformers transformers;

    public OpensearchSearchClient(OpenSearchClient client) {
        this(client, new OpensearchTransformers());
    }

    public OpensearchSearchClient(OpenSearchClient client, OpensearchTransformers transformers) {
        this.client = client;
        this.transformers = transformers;
    }

    public <T> Either<Exception, SearchQueryResponse<T>> search(SearchQueryRequest searchRequest, Class<T> documentClass) {
        try {
            SearchTransfomer<SearchQueryRequest, SearchRequest> requestTransformer = this.getSearchRequestTransformer();
            SearchRequest request = (SearchRequest)requestTransformer.apply((Object)searchRequest);
            SearchResponse rawSearchResponse = this.client.search(request, documentClass);
            SearchResponseTransformer<T> searchResponseTransformer = this.getSearchResponseTransformer();
            SearchQueryResponse<T> response = searchResponseTransformer.apply(rawSearchResponse);
            return Either.right(response);
        }
        catch (IOException ioe) {
            return Either.left((Object)ioe);
        }
        catch (OpenSearchException e) {
            return Either.left((Object)((Object)e));
        }
    }

    private SearchTransfomer<SearchQueryRequest, SearchRequest> getSearchRequestTransformer() {
        return this.transformers.getTransformer(SearchQueryRequest.class);
    }

    private <T> SearchResponseTransformer<T> getSearchResponseTransformer() {
        return new SearchResponseTransformer(this.transformers);
    }

    public void close() throws Exception {
        if (this.client != null) {
            try {
                ((OpenSearchTransport)this.client._transport()).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

