/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.os.transformers.search;

import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.sort.SearchSortOptions;
import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.search.os.transformers.OpensearchTransformer;
import io.camunda.search.os.transformers.OpensearchTransformers;
import io.camunda.search.transformers.SearchTransfomer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.SourceConfig;

public final class SearchRequestTransformer
extends OpensearchTransformer<SearchQueryRequest, SearchRequest> {
    public SearchRequestTransformer(OpensearchTransformers transformers) {
        super(transformers);
    }

    public SearchRequest apply(SearchQueryRequest value) {
        List sort = value.sort();
        Object[] searchAfter = value.searchAfter();
        SearchQuery searchQuery = value.query();
        SearchRequest.Builder builder = new SearchRequest.Builder().index(value.index()).from(value.from()).size(value.size());
        if (searchQuery != null) {
            SearchTransfomer<SearchQuery, Query> queryTransformer = this.getQueryTransformer();
            Query transformedQuery = (Query)queryTransformer.apply((Object)searchQuery);
            builder.query(transformedQuery);
        }
        if (sort != null && !sort.isEmpty()) {
            builder.sort(this.of(sort));
        }
        if (searchAfter != null && searchAfter.length > 0) {
            builder.searchAfter(this.of(searchAfter));
        }
        if (value.source() != null) {
            builder.source(this.of(value.source()));
        }
        return builder.build();
    }

    private List<SortOptions> of(List<SearchSortOptions> values) {
        SearchTransfomer<SearchSortOptions, SortOptions> sortTransformer = this.getSortOptionsTransformer();
        return values.stream().map(arg_0 -> sortTransformer.apply(arg_0)).collect(Collectors.toList());
    }

    private List<String> of(Object[] values) {
        return Arrays.asList(values).stream().map(Object::toString).collect(Collectors.toList());
    }

    private SourceConfig of(SearchSourceConfig value) {
        SearchTransfomer<SearchSourceConfig, SourceConfig> sourceTransformer = this.getSourceConfigTransformer();
        return (SourceConfig)sourceTransformer.apply((Object)value);
    }
}

