/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchBoolQuery;
import io.camunda.search.clients.query.SearchConstantScoreQuery;
import io.camunda.search.clients.query.SearchExistsQuery;
import io.camunda.search.clients.query.SearchHasChildQuery;
import io.camunda.search.clients.query.SearchHasParentQuery;
import io.camunda.search.clients.query.SearchIdsQuery;
import io.camunda.search.clients.query.SearchMatchAllQuery;
import io.camunda.search.clients.query.SearchMatchNoneQuery;
import io.camunda.search.clients.query.SearchMatchQuery;
import io.camunda.search.clients.query.SearchPrefixQuery;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.clients.query.SearchTermQuery;
import io.camunda.search.clients.query.SearchTermsQuery;
import io.camunda.search.clients.query.SearchWildcardQuery;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class SearchQueryBuilders {
    private SearchQueryBuilders() {
    }

    private static SearchQuery must(List<SearchQuery> queries) {
        return SearchQueryBuilders.bool().must(queries).build().toSearchQuery();
    }

    private static SearchQuery should(List<SearchQuery> queries) {
        return SearchQueryBuilders.bool().should(queries).build().toSearchQuery();
    }

    private static SearchQuery mustNot(List<SearchQuery> queries) {
        return SearchQueryBuilders.bool().mustNot(queries).build().toSearchQuery();
    }

    private static SearchQuery map(List<SearchQuery> queries, Function<List<SearchQuery>, SearchQuery> mapper) {
        List<SearchQuery> nonNullQueries = CollectionUtil.withoutNull(queries);
        if (nonNullQueries == null || nonNullQueries.isEmpty()) {
            return null;
        }
        if (nonNullQueries.size() == 1) {
            return nonNullQueries.get(0);
        }
        return mapper.apply(nonNullQueries);
    }

    public static SearchBoolQuery.Builder bool() {
        return new SearchBoolQuery.Builder();
    }

    public static SearchBoolQuery bool(Function<SearchBoolQuery.Builder, ObjectBuilder<SearchBoolQuery>> fn) {
        return fn.apply(SearchQueryBuilders.bool()).build();
    }

    public static SearchQuery and(SearchQuery query, SearchQuery ... queries) {
        return SearchQueryBuilders.and(CollectionUtil.collectValues(query, queries));
    }

    public static SearchQuery and(List<SearchQuery> queries) {
        return SearchQueryBuilders.map(queries, SearchQueryBuilders::must);
    }

    public static SearchQuery not(SearchQuery query, SearchQuery ... queries) {
        return SearchQueryBuilders.not(CollectionUtil.collectValues(query, queries));
    }

    public static SearchQuery not(List<SearchQuery> queries) {
        List<SearchQuery> nonNullQueries = CollectionUtil.withoutNull(queries);
        if (nonNullQueries != null && !nonNullQueries.isEmpty()) {
            return SearchQueryBuilders.mustNot(queries);
        }
        return null;
    }

    public static SearchQuery or(SearchQuery query, SearchQuery ... queries) {
        return SearchQueryBuilders.or(CollectionUtil.collectValues(query, queries));
    }

    public static SearchQuery or(List<SearchQuery> queries) {
        return SearchQueryBuilders.map(queries, SearchQueryBuilders::should);
    }

    public static SearchConstantScoreQuery.Builder constantScore() {
        return new SearchConstantScoreQuery.Builder();
    }

    public static SearchConstantScoreQuery constantScore(Function<SearchConstantScoreQuery.Builder, ObjectBuilder<SearchConstantScoreQuery>> fn) {
        return fn.apply(SearchQueryBuilders.constantScore()).build();
    }

    public static SearchQuery constantScore(SearchQuery query) {
        return SearchQueryBuilders.constantScore((SearchConstantScoreQuery.Builder q) -> q.filter(query)).toSearchQuery();
    }

    public static SearchExistsQuery.Builder exists() {
        return new SearchExistsQuery.Builder();
    }

    public static SearchExistsQuery exists(Function<SearchExistsQuery.Builder, ObjectBuilder<SearchExistsQuery>> fn) {
        return fn.apply(SearchQueryBuilders.exists()).build();
    }

    public static SearchQuery exists(String field) {
        return SearchQueryBuilders.exists((SearchExistsQuery.Builder q) -> q.field(field)).toSearchQuery();
    }

    public static SearchHasChildQuery.Builder hasChild() {
        return new SearchHasChildQuery.Builder();
    }

    public static SearchHasChildQuery hasChild(Function<SearchHasChildQuery.Builder, ObjectBuilder<SearchHasChildQuery>> fn) {
        return fn.apply(SearchQueryBuilders.hasChild()).build();
    }

    public static SearchIdsQuery.Builder ids() {
        return new SearchIdsQuery.Builder();
    }

    public static SearchIdsQuery ids(Function<SearchIdsQuery.Builder, ObjectBuilder<SearchIdsQuery>> fn) {
        return fn.apply(SearchQueryBuilders.ids()).build();
    }

    public static SearchQuery ids(List<String> ids) {
        return SearchQueryBuilders.ids((SearchIdsQuery.Builder q) -> q.values(CollectionUtil.withoutNull(ids))).toSearchQuery();
    }

    public static SearchQuery ids(Collection<String> ids) {
        return SearchQueryBuilders.ids(new ArrayList<String>(Objects.requireNonNullElse(ids, List.of())));
    }

    public static SearchQuery ids(String ... ids) {
        return SearchQueryBuilders.ids(List.of(Objects.requireNonNullElse(ids, new String[0])));
    }

    public static SearchMatchQuery.Builder match() {
        return new SearchMatchQuery.Builder();
    }

    public static SearchMatchQuery match(Function<SearchMatchQuery.Builder, ObjectBuilder<SearchMatchQuery>> fn) {
        return fn.apply(SearchQueryBuilders.match()).build();
    }

    public static <A> SearchQuery match(String field, String value, SearchMatchQuery.SearchMatchQueryOperator operator) {
        return SearchQueryBuilders.match(q -> q.field(field).query(value).operator(operator)).toSearchQuery();
    }

    public static SearchQuery matchAll() {
        return new SearchMatchAllQuery.Builder().build().toSearchQuery();
    }

    public static SearchQuery matchNone() {
        return new SearchMatchNoneQuery.Builder().build().toSearchQuery();
    }

    public static SearchPrefixQuery.Builder prefix() {
        return new SearchPrefixQuery.Builder();
    }

    public static SearchPrefixQuery prefix(Function<SearchPrefixQuery.Builder, ObjectBuilder<SearchPrefixQuery>> fn) {
        return fn.apply(SearchQueryBuilders.prefix()).build();
    }

    public static SearchQuery prefix(String field, String value) {
        return SearchQueryBuilders.prefix(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery.Builder query() {
        return new SearchQuery.Builder();
    }

    public static SearchQuery query(Function<SearchQuery.Builder, ObjectBuilder<SearchQuery>> fn) {
        return fn.apply(SearchQueryBuilders.query()).build();
    }

    public static SearchRangeQuery.Builder range() {
        return new SearchRangeQuery.Builder();
    }

    public static SearchRangeQuery range(Function<SearchRangeQuery.Builder, ObjectBuilder<SearchRangeQuery>> fn) {
        return fn.apply(SearchQueryBuilders.range()).build();
    }

    public static <A> SearchQuery gt(String field, A gt) {
        return SearchRangeQuery.of(q -> q.field(field).gt(gt)).toSearchQuery();
    }

    public static <A> SearchQuery lte(String field, A lte) {
        return SearchRangeQuery.of(q -> q.field(field).lte(lte)).toSearchQuery();
    }

    public static <A> SearchQuery gteLte(String field, A gte, A lte) {
        return SearchRangeQuery.of(q -> q.field(field).gte(gte).lte(lte)).toSearchQuery();
    }

    public static <A> SearchQuery gtLte(String field, A gt, A lte) {
        return SearchRangeQuery.of(q -> q.field(field).gt(gt).lte(lte)).toSearchQuery();
    }

    public static SearchQuery hasChildQuery(String type, SearchQuery query) {
        return SearchQueryBuilders.hasChild(q -> q.query(query).type(type)).toSearchQuery();
    }

    public static SearchTermQuery.Builder term() {
        return new SearchTermQuery.Builder();
    }

    public static SearchTermQuery term(Function<SearchTermQuery.Builder, ObjectBuilder<SearchTermQuery>> fn) {
        return fn.apply(SearchQueryBuilders.term()).build();
    }

    public static SearchQuery term(String field, Integer value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, Long value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, Double value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, String value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchQuery term(String field, boolean value) {
        return SearchQueryBuilders.term(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchTermsQuery.Builder terms() {
        return new SearchTermsQuery.Builder();
    }

    public static SearchTermsQuery terms(Function<SearchTermsQuery.Builder, ObjectBuilder<SearchTermsQuery>> fn) {
        return fn.apply(SearchQueryBuilders.terms()).build();
    }

    public static <C extends Collection<Integer>> SearchQuery intTerms(String field, C values) {
        List fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, (Integer)fieldValues.get(0));
        }
        return SearchTermsQuery.of(q -> q.field(field).intTerms(fieldValues)).toSearchQuery();
    }

    public static <C extends Collection<Long>> SearchQuery longTerms(String field, C values) {
        List fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, (Long)fieldValues.get(0));
        }
        return SearchTermsQuery.of(q -> q.field(field).longTerms(fieldValues)).toSearchQuery();
    }

    public static SearchQuery stringTerms(String field, Collection<String> values) {
        List<String> fieldValues = CollectionUtil.withoutNull(values);
        if (fieldValues == null || fieldValues.isEmpty()) {
            return null;
        }
        if (fieldValues.size() == 1) {
            return SearchQueryBuilders.term(field, fieldValues.get(0));
        }
        return SearchTermsQuery.of(q -> q.field(field).stringTerms(fieldValues)).toSearchQuery();
    }

    public static SearchWildcardQuery.Builder wildcard() {
        return new SearchWildcardQuery.Builder();
    }

    public static SearchWildcardQuery wildcard(Function<SearchWildcardQuery.Builder, ObjectBuilder<SearchWildcardQuery>> fn) {
        return fn.apply(SearchQueryBuilders.wildcard()).build();
    }

    public static SearchQuery wildcardQuery(String field, String value) {
        return SearchQueryBuilders.wildcard(q -> q.field(field).value(value)).toSearchQuery();
    }

    public static SearchHasParentQuery.Builder hasParent() {
        return new SearchHasParentQuery.Builder();
    }

    public static SearchHasParentQuery hasParent(Function<SearchHasParentQuery.Builder, ObjectBuilder<SearchHasParentQuery>> fn) {
        return fn.apply(SearchQueryBuilders.hasParent()).build();
    }

    public static SearchQuery hasParentQuery(String parent, SearchQuery query) {
        return SearchQueryBuilders.hasParent(q -> q.parentType(parent).query(query)).toSearchQuery();
    }
}

