/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.query.SearchQueryOption;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record SearchTermsQuery(String field, List<TypedValue> values) implements SearchQueryOption
{
    public static SearchTermsQuery of(Function<Builder, ObjectBuilder<SearchTermsQuery>> fn) {
        return SearchQueryBuilders.terms(fn);
    }

    public static final class Builder
    implements ObjectBuilder<SearchTermsQuery> {
        private String field;
        private List<TypedValue> terms;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder stringTerms(List<String> values) {
            return this.terms(TypedValue.of(values, TypedValue::of));
        }

        public Builder intTerms(List<Integer> values) {
            return this.terms(TypedValue.of(values, TypedValue::of));
        }

        public Builder longTerms(List<Long> values) {
            return this.terms(TypedValue.of(values, TypedValue::of));
        }

        private Builder terms(List<TypedValue> values) {
            this.terms = CollectionUtil.addValuesToList(this.terms, values);
            return this;
        }

        @Override
        public SearchTermsQuery build() {
            return new SearchTermsQuery(Objects.requireNonNull(this.field), Objects.requireNonNull(this.terms));
        }
    }
}

