/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class CollectionUtil {
    private CollectionUtil() {
    }

    public static <A> List<A> withoutNull(A[] items) {
        if (items != null) {
            return CollectionUtil.withoutNull(Arrays.asList(items));
        }
        return null;
    }

    public static <A> List<A> withoutNull(Collection<A> items) {
        if (items != null) {
            return items.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    public static <T> List<T> addValuesToList(List<T> list, List<T> values) {
        List result = Objects.requireNonNullElse(list, new ArrayList());
        result.addAll(Objects.requireNonNullElse(values, new ArrayList()));
        return result;
    }

    public static <T> Set<T> addValuesToSet(Set<T> set, Collection<T> values) {
        Set result = Objects.requireNonNullElse(set, new HashSet());
        result.addAll(Objects.requireNonNullElse(values, new HashSet()));
        return result;
    }

    public static <T> List<T> collectValuesAsList(T ... values) {
        if (values == null) {
            return List.of();
        }
        return Arrays.stream(values).toList();
    }

    public static <T> List<T> collectValues(T value, T ... values) {
        ArrayList<T> collectedValues = new ArrayList<T>();
        collectedValues.add(value);
        if (values != null && values.length > 0) {
            collectedValues.addAll(Arrays.asList(values));
        }
        return collectedValues;
    }
}

