/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.types;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public record TypedValue(ValueType type, Object value) {
    public static final TypedValue NULL = new TypedValue(ValueType.NULL, null);
    public static final TypedValue TRUE = new TypedValue(ValueType.BOOLEAN, Boolean.TRUE);
    public static final TypedValue FALSE = new TypedValue(ValueType.BOOLEAN, Boolean.FALSE);

    public TypedValue(ValueType type, Object value) {
        if (value == null && type != ValueType.NULL) {
            throw new IllegalArgumentException("Expected non-null value, for value type " + type.name());
        }
        this.type = type;
        this.value = type == ValueType.NULL ? null : value;
    }

    public boolean isNull() {
        return this.type == ValueType.NULL;
    }

    public boolean isDouble() {
        return this.type == ValueType.DOUBLE;
    }

    public double doubleValue() {
        return (Double)this.value;
    }

    public boolean isInteger() {
        return this.type == ValueType.INTEGER;
    }

    public int intValue() {
        return (Integer)this.value;
    }

    public boolean isLong() {
        return this.type == ValueType.LONG;
    }

    public long longValue() {
        return (Long)this.value;
    }

    public boolean isBoolean() {
        return this.type == ValueType.BOOLEAN;
    }

    public boolean booleanValue() {
        return (Boolean)this.value;
    }

    public boolean isString() {
        return this.type == ValueType.STRING;
    }

    public String stringValue() {
        return (String)this.value;
    }

    public static TypedValue of(int value) {
        return new TypedValue(ValueType.INTEGER, value);
    }

    public static TypedValue of(long value) {
        return new TypedValue(ValueType.LONG, value);
    }

    public static TypedValue of(double value) {
        return new TypedValue(ValueType.DOUBLE, value);
    }

    public static TypedValue of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static TypedValue of(String value) {
        if (value == null) {
            return NULL;
        }
        return new TypedValue(ValueType.STRING, value);
    }

    public static <T> List<TypedValue> of(List<T> values, Function<T, TypedValue> mapper) {
        if (values == null) {
            throw new IllegalArgumentException("Expected non-null values collection, for typed values.");
        }
        return values.stream().map(mapper).collect(Collectors.toList());
    }

    public static TypedValue toTypedValue(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value instanceof TypedValue) {
            return (TypedValue)value;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return TypedValue.of((String)value);
        }
        if (Integer.class.isAssignableFrom(value.getClass())) {
            return TypedValue.of((Integer)value);
        }
        if (Long.class.isAssignableFrom(value.getClass())) {
            return TypedValue.of((Long)value);
        }
        if (Double.class.isAssignableFrom(value.getClass())) {
            return TypedValue.of((Double)value);
        }
        if (Boolean.class.isAssignableFrom(value.getClass())) {
            return TypedValue.of((Boolean)value);
        }
        throw new IllegalArgumentException("Non-supported type: " + String.valueOf(value.getClass()));
    }

    public static enum ValueType {
        DOUBLE,
        INTEGER,
        LONG,
        BOOLEAN,
        STRING,
        NULL;

    }
}

