/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.core;

import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public record SearchQueryResponse<T>(long totalHits, String scrollId, List<SearchQueryHit<T>> hits) {
    public static <T> SearchQueryResponse<T> of(Function<Builder<T>, ObjectBuilder<SearchQueryResponse<T>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public static final class Builder<T>
    implements ObjectBuilder<SearchQueryResponse<T>> {
        private long totalHits;
        private String scrollId;
        private List<SearchQueryHit<T>> hits;

        public Builder<T> totalHits(long value) {
            this.totalHits = value;
            return this;
        }

        public Builder<T> scrollId(String value) {
            this.scrollId = value;
            return this;
        }

        public Builder<T> hits(List<SearchQueryHit<T>> value) {
            this.hits = value;
            return this;
        }

        @Override
        public SearchQueryResponse<T> build() {
            return new SearchQueryResponse(this.totalHits, this.scrollId, Objects.requireNonNullElse(this.hits, Collections.emptyList()));
        }
    }
}

