/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.query;

import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.query.SearchQueryOption;
import io.camunda.util.ObjectBuilder;
import java.util.Objects;
import java.util.function.Function;

public record SearchRangeQuery(String field, Object gt, Object gte, Object lt, Object lte, String from, String to, String format) implements SearchQueryOption
{
    static SearchRangeQuery of(Function<Builder, ObjectBuilder<SearchRangeQuery>> fn) {
        return SearchQueryBuilders.range(fn);
    }

    public static final class Builder
    implements ObjectBuilder<SearchRangeQuery> {
        private String field;
        private Object gt;
        private Object gte;
        private Object lt;
        private Object lte;
        private String from;
        private String to;
        private String format;

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder gt(Object value) {
            this.gt = value;
            return this;
        }

        public Builder gte(Object value) {
            this.gte = value;
            return this;
        }

        public Builder lt(Object value) {
            this.lt = value;
            return this;
        }

        public Builder lte(Object value) {
            this.lte = value;
            return this;
        }

        public Builder from(String value) {
            this.from = value;
            return this;
        }

        public Builder to(String value) {
            this.to = value;
            return this;
        }

        public Builder format(String value) {
            this.format = value;
            return this;
        }

        @Override
        public SearchRangeQuery build() {
            return new SearchRangeQuery(Objects.requireNonNull(this.field), this.gt, this.gte, this.lt, this.lte, this.from, this.to, this.format);
        }
    }
}

