/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.search.clients.sort;

import io.camunda.search.clients.sort.SearchFieldSort;
import io.camunda.search.clients.sort.SearchSortOptions;
import io.camunda.search.clients.sort.SortOrder;
import io.camunda.util.ObjectBuilder;
import java.util.function.Function;

public final class SortOptionsBuilders {
    private SortOptionsBuilders() {
    }

    public static SortOrder toSortOrder(String sortOrder) {
        return SortOrder.valueOf(sortOrder);
    }

    public static SortOrder reverseOrder(SortOrder sortOrder) {
        return sortOrder == SortOrder.ASC ? SortOrder.DESC : SortOrder.ASC;
    }

    public static SearchSortOptions sortOptions(String field, SortOrder sortOrder) {
        return SearchSortOptions.of(so -> so.field(sf -> sf.field(field).order(sortOrder)));
    }

    public static SearchSortOptions sortOptions(String field, SortOrder sortOrder, String missing) {
        return SearchSortOptions.of(so -> so.field(sf -> sf.field(field).order(sortOrder).missing(missing)));
    }

    public static SearchSortOptions.Builder sort() {
        return new SearchSortOptions.Builder();
    }

    public static SearchSortOptions sort(Function<SearchSortOptions.Builder, ObjectBuilder<SearchSortOptions>> fn) {
        return fn.apply(SortOptionsBuilders.sort()).build();
    }

    public static SearchFieldSort.Builder field() {
        return new SearchFieldSort.Builder();
    }

    public static SearchFieldSort field(Function<SearchFieldSort.Builder, ObjectBuilder<SearchFieldSort>> fn) {
        return fn.apply(SortOptionsBuilders.field()).build();
    }
}

