/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.security.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public record Authentication(Long authenticatedUserKey, List<Long> authenticatedGroupKeys, List<String> authenticatedTenantIds, String token) {
    public static Authentication of(Function<Builder, Builder> builderFunction) {
        return builderFunction.apply(new Builder()).build();
    }

    public static final class Builder {
        private Long userKey;
        private final List<Long> groupKeys = new ArrayList<Long>();
        private final List<String> tenants = new ArrayList<String>();
        private String token;

        public Builder user(Long value) {
            this.userKey = value;
            return this;
        }

        public Builder group(Long value) {
            return this.groupKeys(List.of(value));
        }

        public Builder groupKeys(List<Long> values) {
            if (values != null) {
                this.groupKeys.addAll(values);
            }
            return this;
        }

        public Builder tenant(String tenant) {
            return this.tenants(List.of(tenant));
        }

        public Builder tenants(List<String> values) {
            if (values != null) {
                this.tenants.addAll(values);
            }
            return this;
        }

        public Builder token(String value) {
            this.token = value;
            return this;
        }

        public Authentication build() {
            return new Authentication(this.userKey, Collections.unmodifiableList(this.groupKeys), Collections.unmodifiableList(this.tenants), this.token);
        }
    }
}

