/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.security.auth;

import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import java.util.function.Function;

public record Authorization(AuthorizationResourceType resourceType, PermissionType permissionType) {
    public static final String WILDCARD = "*";

    public static Authorization of(Function<Builder, Builder> builderFunction) {
        return builderFunction.apply(new Builder()).build();
    }

    public static class Builder {
        private AuthorizationResourceType resourceType;
        private PermissionType permissionType;

        public Builder resourceType(AuthorizationResourceType resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder permissionType(PermissionType permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        public Builder processDefinition() {
            return this.resourceType(AuthorizationResourceType.PROCESS_DEFINITION);
        }

        public Builder decisionDefinition() {
            return this.resourceType(AuthorizationResourceType.DECISION_DEFINITION);
        }

        public Builder decisionRequirementsDefinition() {
            return this.resourceType(AuthorizationResourceType.DECISION_REQUIREMENTS_DEFINITION);
        }

        public Builder mapping() {
            return this.resourceType(AuthorizationResourceType.MAPPING_RULE);
        }

        public Builder role() {
            return this.resourceType(AuthorizationResourceType.ROLE);
        }

        public Builder tenant() {
            return this.resourceType(AuthorizationResourceType.TENANT);
        }

        public Builder authorization() {
            return this.resourceType(AuthorizationResourceType.AUTHORIZATION);
        }

        public Builder user() {
            return this.resourceType(AuthorizationResourceType.USER);
        }

        public Builder read() {
            return this.permissionType(PermissionType.READ);
        }

        public Builder readProcessInstance() {
            return this.permissionType(PermissionType.READ_PROCESS_INSTANCE);
        }

        public Builder readUserTask() {
            return this.permissionType(PermissionType.READ_USER_TASK);
        }

        public Builder readDecisionInstance() {
            return this.permissionType(PermissionType.READ_DECISION_INSTANCE);
        }

        public Authorization build() {
            return new Authorization(this.resourceType, this.permissionType);
        }
    }
}

