/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.security.auth;

import io.camunda.security.auth.Authentication;
import io.camunda.security.auth.Authorization;
import java.util.function.Function;

public record SecurityContext(Authentication authentication, Authorization authorization) {
    public boolean requiresAuthorizationChecks() {
        return this.authentication != null && this.authorization != null;
    }

    public static SecurityContext of(Function<Builder, Builder> builderFunction) {
        return builderFunction.apply(new Builder()).build();
    }

    public static SecurityContext withoutAuthentication() {
        return new Builder().build();
    }

    public static class Builder {
        private Authentication authentication;
        private Authorization authorization;

        public Builder withAuthentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder withAuthentication(Function<Authentication.Builder, Authentication.Builder> builderFunction) {
            return this.withAuthentication(Authentication.of(builderFunction));
        }

        public Builder withAuthorization(Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public Builder withAuthorization(Function<Authorization.Builder, Authorization.Builder> builderFunction) {
            return this.withAuthorization(Authorization.of(builderFunction));
        }

        public SecurityContext build() {
            return new SecurityContext(this.authentication, this.authorization);
        }
    }
}

