/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.CamundaServiceException;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.util.ObjectBuilder;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public abstract class ApiServices<T extends ApiServices<T>> {
    protected final BrokerClient brokerClient;
    protected final CamundaSearchClient searchClient;
    protected final Authentication authentication;
    protected final ServiceTransformers transformers;

    protected ApiServices(BrokerClient brokerClient, CamundaSearchClient searchClient, Authentication authentication) {
        this(brokerClient, searchClient, null, authentication);
    }

    protected ApiServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        this.brokerClient = brokerClient;
        this.searchClient = searchClient;
        this.authentication = authentication;
        this.transformers = Optional.ofNullable(transformers).orElseGet(ServiceTransformers::newInstance);
    }

    public abstract T withAuthentication(Authentication var1);

    public T withAuthentication(Function<Authentication.Builder, ObjectBuilder<Authentication>> fn) {
        return this.withAuthentication((Authentication)fn.apply(new Authentication.Builder()).build());
    }

    protected <R> CompletableFuture<R> sendBrokerRequest(BrokerRequest<R> brokerRequest) {
        return this.sendBrokerRequestWithFullResponse(brokerRequest).thenApply(BrokerResponse::getResponse);
    }

    protected <R> CompletableFuture<BrokerResponse<R>> sendBrokerRequestWithFullResponse(BrokerRequest<R> brokerRequest) {
        brokerRequest.setAuthorization(this.authentication.token());
        return this.brokerClient.sendRequest(brokerRequest).handleAsync((response, error) -> {
            if (error != null) {
                throw new CamundaServiceException((Throwable)error);
            }
            if (response.isError()) {
                throw new CamundaServiceException(response.getError());
            }
            if (response.isRejection()) {
                throw new CamundaServiceException(response.getRejection());
            }
            return response;
        });
    }

    protected DirectBuffer getDocumentOrEmpty(Map<String, Object> value) {
        return value == null || value.isEmpty() ? DocumentValue.EMPTY_DOCUMENT : new UnsafeBuffer(MsgPackConverter.convertToMsgPack(value));
    }
}

