/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.entities.AuthorizationEntity;
import io.camunda.service.search.core.SearchQueryService;
import io.camunda.service.search.query.AuthorizationQuery;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerAuthorizationPatchRequest;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionAction;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AuthorizationServices<T>
extends SearchQueryService<AuthorizationServices<T>, AuthorizationQuery, AuthorizationEntity> {
    public AuthorizationServices(BrokerClient brokerClient, CamundaSearchClient dataStoreClient) {
        this(brokerClient, dataStoreClient, null, null);
    }

    public AuthorizationServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public AuthorizationServices<T> withAuthentication(Authentication authentication) {
        return new AuthorizationServices<T>(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    @Override
    public SearchQueryResult<AuthorizationEntity> search(AuthorizationQuery query) {
        return this.executor.search(query, AuthorizationEntity.class);
    }

    public CompletableFuture<AuthorizationRecord> patchAuthorization(PatchAuthorizationRequest request) {
        BrokerAuthorizationPatchRequest brokerRequest = new BrokerAuthorizationPatchRequest().setOwnerKey(Long.valueOf(request.ownerKey())).setAction(request.action()).setResourceType(request.resourceType());
        request.permissions().forEach((arg_0, arg_1) -> ((BrokerAuthorizationPatchRequest)brokerRequest).addPermissions(arg_0, arg_1));
        return this.sendBrokerRequest(brokerRequest);
    }

    public record PatchAuthorizationRequest(long ownerKey, PermissionAction action, AuthorizationResourceType resourceType, Map<PermissionType, List<String>> permissions) {
    }
}

