/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.entities.DecisionDefinitionEntity;
import io.camunda.service.entities.DecisionRequirementsEntity;
import io.camunda.service.exception.NotFoundException;
import io.camunda.service.search.core.SearchQueryService;
import io.camunda.service.search.query.DecisionDefinitionQuery;
import io.camunda.service.search.query.DecisionRequirementsQuery;
import io.camunda.service.search.query.SearchQueryBuilders;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.util.ObjectBuilder;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerEvaluateDecisionRequest;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class DecisionDefinitionServices
extends SearchQueryService<DecisionDefinitionServices, DecisionDefinitionQuery, DecisionDefinitionEntity> {
    public DecisionDefinitionServices(BrokerClient brokerClient, CamundaSearchClient dataStoreClient) {
        this(brokerClient, dataStoreClient, null, null);
    }

    public DecisionDefinitionServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public DecisionDefinitionServices withAuthentication(Authentication authentication) {
        return new DecisionDefinitionServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    @Override
    public SearchQueryResult<DecisionDefinitionEntity> search(DecisionDefinitionQuery query) {
        return this.executor.search(query, DecisionDefinitionEntity.class);
    }

    @Override
    public SearchQueryResult<DecisionDefinitionEntity> search(Function<DecisionDefinitionQuery.Builder, ObjectBuilder<DecisionDefinitionQuery>> fn) {
        return this.search(SearchQueryBuilders.decisionDefinitionSearchQuery(fn));
    }

    public String getDecisionDefinitionXml(Long decisionKey) {
        DecisionDefinitionQuery decisionDefinitionQuery = SearchQueryBuilders.decisionDefinitionSearchQuery(q -> q.filter(f -> f.decisionKeys(decisionKey)));
        DecisionDefinitionEntity decisionDefinition = (DecisionDefinitionEntity)this.search(decisionDefinitionQuery).items().stream().findFirst().orElseThrow(() -> new NotFoundException("DecisionDefinition with decisionKey=%d cannot be found".formatted(decisionKey)));
        Long decisionRequirementsKey = decisionDefinition.decisionRequirementsKey();
        DecisionRequirementsQuery decisionRequirementsQuery = SearchQueryBuilders.decisionRequirementsSearchQuery(q -> q.filter(f -> f.decisionRequirementsKeys(decisionRequirementsKey)).resultConfig(r -> (ObjectBuilder)r.xml().include()));
        return this.executor.search(decisionRequirementsQuery, DecisionRequirementsEntity.class).items().stream().findFirst().map(DecisionRequirementsEntity::xml).orElseThrow(() -> new NotFoundException("DecisionRequirements with decisionRequirementsKey=%d cannot be found".formatted(decisionRequirementsKey)));
    }

    public CompletableFuture<BrokerResponse<DecisionEvaluationRecord>> evaluateDecision(String definitionId, Long definitionKey, Map<String, Object> variables, String tenantId) {
        return this.sendBrokerRequestWithFullResponse(new BrokerEvaluateDecisionRequest().setDecisionId(definitionId).setDecisionKey(definitionKey.longValue()).setVariables(this.getDocumentOrEmpty(variables)).setTenantId(tenantId));
    }
}

