/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.document.api.DocumentCreationRequest;
import io.camunda.document.api.DocumentError;
import io.camunda.document.api.DocumentLink;
import io.camunda.document.api.DocumentMetadataModel;
import io.camunda.document.api.DocumentReference;
import io.camunda.document.api.DocumentStoreRecord;
import io.camunda.document.store.SimpleDocumentStoreRegistry;
import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.ApiServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.concurrent.CompletableFuture;

public class DocumentServices
extends ApiServices<DocumentServices> {
    private final SimpleDocumentStoreRegistry registry = new SimpleDocumentStoreRegistry();

    public DocumentServices(BrokerClient brokerClient, CamundaSearchClient searchClient) {
        this(brokerClient, searchClient, null, null);
    }

    public DocumentServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public DocumentServices withAuthentication(Authentication authentication) {
        return new DocumentServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public CompletableFuture<DocumentReferenceResponse> createDocument(DocumentCreateRequest request) {
        DocumentCreationRequest storeRequest = new DocumentCreationRequest(request.documentId, request.contentInputStream, request.metadata);
        DocumentStoreRecord storeRecord = this.getDocumentStore(request.storeId);
        return storeRecord.instance().createDocument(storeRequest).thenApply(result -> {
            if (result.isLeft()) {
                throw new DocumentException("Failed to create document", (DocumentError)result.getLeft());
            }
            return new DocumentReferenceResponse(((DocumentReference)result.get()).documentId(), storeRecord.storeId(), ((DocumentReference)result.get()).metadata());
        });
    }

    public InputStream getDocumentContent(String documentId, String storeId) {
        DocumentStoreRecord storeRecord = this.getDocumentStore(storeId);
        return (InputStream)((CompletableFuture)storeRecord.instance().getDocument(documentId).thenApply(result -> {
            if (result.isLeft()) {
                throw new DocumentException("Failed to get document", (DocumentError)result.getLeft());
            }
            return (InputStream)result.get();
        })).join();
    }

    public CompletableFuture<Void> deleteDocument(String documentId, String storeId) {
        DocumentStoreRecord storeRecord = this.getDocumentStore(storeId);
        return storeRecord.instance().deleteDocument(documentId).thenAccept(result -> {
            if (result.isLeft()) {
                throw new DocumentException("Failed to delete document", (DocumentError)result.getLeft());
            }
        });
    }

    public CompletableFuture<DocumentLink> createLink(String documentId, String storeId, DocumentLinkParams params) {
        DocumentStoreRecord storeRecord = this.getDocumentStore(storeId);
        long ttl = params.expiresAt().toInstant().getEpochSecond() - ZonedDateTime.now().toInstant().getEpochSecond();
        return storeRecord.instance().createLink(documentId, ttl).thenApply(result -> {
            if (result.isLeft()) {
                throw new DocumentException("Failed to create link", (DocumentError)result.getLeft());
            }
            return (DocumentLink)result.get();
        });
    }

    private DocumentStoreRecord getDocumentStore(String id) {
        if (id == null) {
            return this.registry.getDefaultDocumentStore();
        }
        return this.registry.getDocumentStore(id);
    }

    public record DocumentCreateRequest(String documentId, String storeId, InputStream contentInputStream, DocumentMetadataModel metadata) {
    }

    public record DocumentLinkParams(ZonedDateTime expiresAt) {
    }

    public static class DocumentException
    extends RuntimeException {
        private final DocumentError documentError;

        public DocumentException(String message, DocumentError error) {
            this.documentError = error;
        }

        public DocumentException(String message, DocumentError error, Throwable cause) {
            this.documentError = error;
        }

        public DocumentError getDocumentError() {
            return this.documentError;
        }
    }

    public record DocumentReferenceResponse(String documentId, String storeId, DocumentMetadataModel metadata) {
    }
}

