/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.ApiServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerSetVariablesRequest;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ElementInstanceServices
extends ApiServices<ElementInstanceServices> {
    public ElementInstanceServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public ElementInstanceServices withAuthentication(Authentication authentication) {
        return new ElementInstanceServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public CompletableFuture<VariableDocumentRecord> setVariables(SetVariablesRequest request) {
        BrokerSetVariablesRequest brokerRequest = new BrokerSetVariablesRequest().setElementInstanceKey(request.elementInstanceKey()).setVariables(this.getDocumentOrEmpty(request.variables())).setLocal(request.local().booleanValue());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public record SetVariablesRequest(long elementInstanceKey, Map<String, Object> variables, Boolean local, Long operationReference) {
    }
}

