/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.ApiServices;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCompleteJobRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerFailJobRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerThrowErrorRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUpdateJobRequest;
import io.camunda.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.camunda.zeebe.gateway.impl.job.ResponseObserver;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public final class JobServices<T>
extends ApiServices<JobServices<T>> {
    private final ActivateJobsHandler<T> activateJobsHandler;

    public JobServices(BrokerClient brokerClient, ActivateJobsHandler<T> activateJobsHandler, CamundaSearchClient dataStoreClient) {
        this(brokerClient, activateJobsHandler, dataStoreClient, null, null);
    }

    public JobServices(BrokerClient brokerClient, ActivateJobsHandler<T> activateJobsHandler, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
        this.activateJobsHandler = activateJobsHandler;
    }

    @Override
    public JobServices<T> withAuthentication(Authentication authentication) {
        return new JobServices<T>(this.brokerClient, this.activateJobsHandler, this.searchClient, this.transformers, authentication);
    }

    public void activateJobs(ActivateJobsRequest request, ResponseObserver<T> responseObserver, Consumer<Runnable> cancelationHandlerConsumer) {
        BrokerActivateJobsRequest brokerRequest = new BrokerActivateJobsRequest(request.type()).setMaxJobsToActivate(request.maxJobsToActivate()).setTenantIds(request.tenantIds()).setTimeout(request.timeout()).setWorker(request.worker()).setVariables(request.fetchVariable());
        this.activateJobsHandler.activateJobs(brokerRequest, responseObserver, cancelationHandlerConsumer, request.requestTimeout());
    }

    public CompletableFuture<JobRecord> failJob(long jobKey, int retries, String errorMessage, Long retryBackOff, Map<String, Object> variables) {
        BrokerFailJobRequest request = new BrokerFailJobRequest(jobKey, retries, retryBackOff.longValue()).setVariables(this.getDocumentOrEmpty(variables)).setErrorMessage(errorMessage);
        return this.sendBrokerRequest(request);
    }

    public CompletableFuture<JobRecord> errorJob(long jobKey, String errorCode, String errorMessage, Map<String, Object> variables) {
        BrokerThrowErrorRequest request = new BrokerThrowErrorRequest(jobKey, errorCode).setErrorMessage(errorMessage).setVariables(this.getDocumentOrEmpty(variables));
        return this.sendBrokerRequest(request);
    }

    public CompletableFuture<JobRecord> completeJob(long jobKey, Map<String, Object> variables) {
        return this.sendBrokerRequest(new BrokerCompleteJobRequest(jobKey, this.getDocumentOrEmpty(variables)));
    }

    public CompletableFuture<JobRecord> updateJob(long jobKey, UpdateJobChangeset changeset) {
        return this.sendBrokerRequest(new BrokerUpdateJobRequest(jobKey, changeset.retries(), changeset.timeout()));
    }

    public record ActivateJobsRequest(String type, int maxJobsToActivate, List<String> tenantIds, long timeout, String worker, List<String> fetchVariable, long requestTimeout) {
    }

    public record UpdateJobChangeset(Integer retries, Long timeout) {
    }
}

