/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.entities.ProcessInstanceEntity;
import io.camunda.service.search.core.SearchQueryService;
import io.camunda.service.search.query.ProcessInstanceQuery;
import io.camunda.service.search.query.SearchQueryBuilders;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.util.ObjectBuilder;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCancelProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCreateProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCreateProcessInstanceWithResultRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerMigrateProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerModifyProcessInstanceRequest;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationMappingInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public final class ProcessInstanceServices
extends SearchQueryService<ProcessInstanceServices, ProcessInstanceQuery, ProcessInstanceEntity> {
    public ProcessInstanceServices(BrokerClient brokerClient, CamundaSearchClient dataStoreClient) {
        this(brokerClient, dataStoreClient, null, null);
    }

    public ProcessInstanceServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public ProcessInstanceServices withAuthentication(Authentication authentication) {
        return new ProcessInstanceServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    @Override
    public SearchQueryResult<ProcessInstanceEntity> search(ProcessInstanceQuery query) {
        return this.executor.search(query, ProcessInstanceEntity.class);
    }

    @Override
    public SearchQueryResult<ProcessInstanceEntity> search(Function<ProcessInstanceQuery.Builder, ObjectBuilder<ProcessInstanceQuery>> fn) {
        return this.search(SearchQueryBuilders.processInstanceSearchQuery(fn));
    }

    public CompletableFuture<ProcessInstanceCreationRecord> createProcessInstance(ProcessInstanceCreateRequest request) {
        BrokerCreateProcessInstanceRequest brokerRequest = new BrokerCreateProcessInstanceRequest().setBpmnProcessId(request.bpmnProcessId()).setKey(request.processDefinitionKey().longValue()).setVersion(request.version().intValue()).setTenantId(request.tenantId()).setVariables(this.getDocumentOrEmpty(request.variables())).setInstructions(request.startInstructions());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public CompletableFuture<ProcessInstanceResultRecord> createProcessInstanceWithResult(ProcessInstanceCreateRequest request) {
        BrokerCreateProcessInstanceWithResultRequest brokerRequest = new BrokerCreateProcessInstanceWithResultRequest().setBpmnProcessId(request.bpmnProcessId()).setKey(request.processDefinitionKey().longValue()).setVersion(request.version().intValue()).setTenantId(request.tenantId()).setVariables(this.getDocumentOrEmpty(request.variables())).setInstructions(request.startInstructions()).setFetchVariables(request.fetchVariables());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public CompletableFuture<ProcessInstanceRecord> cancelProcessInstance(ProcessInstanceCancelRequest request) {
        BrokerCancelProcessInstanceRequest brokerRequest = new BrokerCancelProcessInstanceRequest().setProcessInstanceKey(request.processInstanceKey().longValue());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public CompletableFuture<ProcessInstanceMigrationRecord> migrateProcessInstance(ProcessInstanceMigrateRequest request) {
        BrokerMigrateProcessInstanceRequest brokerRequest = new BrokerMigrateProcessInstanceRequest().setProcessInstanceKey(request.processInstanceKey().longValue()).setTargetProcessDefinitionKey(request.targetProcessDefinitionKey().longValue()).setMappingInstructions(request.mappingInstructions());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public CompletableFuture<ProcessInstanceModificationRecord> modifyProcessInstance(ProcessInstanceModifyRequest request) {
        BrokerModifyProcessInstanceRequest brokerRequest = new BrokerModifyProcessInstanceRequest().setProcessInstanceKey(request.processInstanceKey().longValue()).addActivationInstructions(request.activateInstructions()).addTerminationInstructions(request.terminateInstructions());
        if (request.operationReference() != null) {
            brokerRequest.setOperationReference(request.operationReference().longValue());
        }
        return this.sendBrokerRequest(brokerRequest);
    }

    public record ProcessInstanceCreateRequest(Long processDefinitionKey, String bpmnProcessId, Integer version, Map<String, Object> variables, String tenantId, Boolean awaitCompletion, Long requestTimeout, Long operationReference, List<ProcessInstanceCreationStartInstruction> startInstructions, List<String> fetchVariables) {
    }

    public record ProcessInstanceCancelRequest(Long processInstanceKey, Long operationReference) {
    }

    public record ProcessInstanceMigrateRequest(Long processInstanceKey, Long targetProcessDefinitionKey, List<ProcessInstanceMigrationMappingInstruction> mappingInstructions, Long operationReference) {
    }

    public record ProcessInstanceModifyRequest(Long processInstanceKey, List<ProcessInstanceModificationActivateInstruction> activateInstructions, List<ProcessInstanceModificationTerminateInstruction> terminateInstructions, Long operationReference) {
    }
}

