/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service;

import io.camunda.search.clients.CamundaSearchClient;
import io.camunda.service.entities.UserEntity;
import io.camunda.service.search.core.SearchQueryService;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.search.query.UserQuery;
import io.camunda.service.security.auth.Authentication;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUserCreateRequest;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import java.util.concurrent.CompletableFuture;

public class UserServices
extends SearchQueryService<UserServices, UserQuery, UserEntity> {
    public UserServices(BrokerClient brokerClient, CamundaSearchClient dataStoreClient) {
        this(brokerClient, dataStoreClient, null, null);
    }

    public UserServices(BrokerClient brokerClient, CamundaSearchClient searchClient, ServiceTransformers transformers, Authentication authentication) {
        super(brokerClient, searchClient, transformers, authentication);
    }

    @Override
    public SearchQueryResult<UserEntity> search(UserQuery query) {
        return this.executor.search(query, UserEntity.class);
    }

    @Override
    public UserServices withAuthentication(Authentication authentication) {
        return new UserServices(this.brokerClient, this.searchClient, this.transformers, authentication);
    }

    public CompletableFuture<UserRecord> createUser(CreateUserRequest request) {
        return this.sendBrokerRequest(new BrokerUserCreateRequest().setUsername(request.username()).setName(request.name()).setEmail(request.email()).setPassword(request.password()));
    }

    public record CreateUserRequest(String username, String name, String email, String password) {
    }
}

