/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.filter;

import io.camunda.service.entities.IncidentEntity;
import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record IncidentFilter(List<Long> keys, List<Long> processDefinitionKeys, List<String> bpmnProcessIds, List<Long> processInstanceKeys, List<IncidentEntity.ErrorType> errorTypes, List<String> errorMessages, List<String> flowNodeIds, List<Long> flowNodeInstanceKeys, DateValueFilter creationTime, List<IncidentEntity.IncidentState> states, List<Long> jobKeys, List<String> treePaths, List<String> tenantIds) implements FilterBase
{

    public static final class Builder
    implements ObjectBuilder<IncidentFilter> {
        private List<Long> keys;
        private List<Long> processDefinitionKeys;
        private List<String> bpmnProcessIds;
        private List<Long> processInstanceKeys;
        private List<IncidentEntity.ErrorType> errorTypes;
        private List<String> errorMessages;
        private List<String> flowNodeIds;
        private List<Long> flowNodeInstanceKeys;
        private DateValueFilter creationTimeFilter;
        private List<IncidentEntity.IncidentState> states;
        private List<Long> jobKeys;
        private List<String> treePaths;
        private List<String> tenantIds;

        public Builder keys(Long value, Long ... values) {
            return this.keys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder keys(List<Long> values) {
            this.keys = CollectionUtil.addValuesToList(this.keys, values);
            return this;
        }

        public Builder processDefinitionKeys(Long value, Long ... values) {
            return this.processDefinitionKeys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder processDefinitionKeys(List<Long> values) {
            this.processDefinitionKeys = CollectionUtil.addValuesToList(this.processDefinitionKeys, values);
            return this;
        }

        public Builder bpmnProcessIds(String value, String ... values) {
            return this.bpmnProcessIds(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder bpmnProcessIds(List<String> values) {
            this.bpmnProcessIds = CollectionUtil.addValuesToList(this.bpmnProcessIds, values);
            return this;
        }

        public Builder processInstanceKeys(Long value, Long ... values) {
            return this.processInstanceKeys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder processInstanceKeys(List<Long> values) {
            this.processInstanceKeys = CollectionUtil.addValuesToList(this.processInstanceKeys, values);
            return this;
        }

        public Builder errorTypes(IncidentEntity.ErrorType value, IncidentEntity.ErrorType ... values) {
            return this.errorTypes(CollectionUtil.collectValues((Object)((Object)value), (Object[])values));
        }

        public Builder errorTypes(List<IncidentEntity.ErrorType> values) {
            this.errorTypes = CollectionUtil.addValuesToList(this.errorTypes, values);
            return this;
        }

        public Builder errorMessages(String value, String ... values) {
            return this.errorMessages(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder errorMessages(List<String> values) {
            this.errorMessages = CollectionUtil.addValuesToList(this.errorMessages, values);
            return this;
        }

        public Builder creationTime(DateValueFilter value) {
            this.creationTimeFilter = value;
            return this;
        }

        public Builder flowNodeIds(String value, String ... values) {
            return this.flowNodeIds(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder flowNodeIds(List<String> values) {
            this.flowNodeIds = CollectionUtil.addValuesToList(this.flowNodeIds, values);
            return this;
        }

        public Builder flowNodeInstanceKeys(Long value, Long ... values) {
            return this.flowNodeInstanceKeys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder flowNodeInstanceKeys(List<Long> values) {
            this.flowNodeInstanceKeys = CollectionUtil.addValuesToList(this.flowNodeInstanceKeys, values);
            return this;
        }

        public Builder states(IncidentEntity.IncidentState value, IncidentEntity.IncidentState ... values) {
            return this.states(CollectionUtil.collectValues((Object)((Object)value), (Object[])values));
        }

        public Builder states(List<IncidentEntity.IncidentState> values) {
            this.states = CollectionUtil.addValuesToList(this.states, values);
            return this;
        }

        public Builder jobKeys(Long value, Long ... values) {
            return this.jobKeys(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder jobKeys(List<Long> values) {
            this.jobKeys = CollectionUtil.addValuesToList(this.jobKeys, values);
            return this;
        }

        public Builder treePaths(String value, String ... values) {
            return this.treePaths(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder treePaths(List<String> values) {
            this.treePaths = CollectionUtil.addValuesToList(this.treePaths, values);
            return this;
        }

        public Builder tenantIds(String value, String ... values) {
            return this.tenantIds(CollectionUtil.collectValues((Object)value, (Object[])values));
        }

        public Builder tenantIds(List<String> values) {
            this.tenantIds = CollectionUtil.addValuesToList(this.tenantIds, values);
            return this;
        }

        public IncidentFilter build() {
            return new IncidentFilter(Objects.requireNonNullElse(this.keys, Collections.emptyList()), Objects.requireNonNullElse(this.processDefinitionKeys, Collections.emptyList()), Objects.requireNonNullElse(this.bpmnProcessIds, Collections.emptyList()), Objects.requireNonNullElse(this.processInstanceKeys, Collections.emptyList()), Objects.requireNonNullElse(this.errorTypes, Collections.emptyList()), Objects.requireNonNullElse(this.errorMessages, Collections.emptyList()), Objects.requireNonNullElse(this.flowNodeIds, Collections.emptyList()), Objects.requireNonNullElse(this.flowNodeInstanceKeys, Collections.emptyList()), this.creationTimeFilter, Objects.requireNonNullElse(this.states, Collections.emptyList()), Objects.requireNonNullElse(this.jobKeys, Collections.emptyList()), Objects.requireNonNullElse(this.treePaths, Collections.emptyList()), Objects.requireNonNullElse(this.tenantIds, Collections.emptyList()));
        }
    }
}

