/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.query;

import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.filter.ProcessInstanceFilter;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.SearchQueryBase;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.query.TypedSearchQueryBuilder;
import io.camunda.service.search.result.ProcessInstanceQueryResultConfig;
import io.camunda.service.search.result.QueryResultConfig;
import io.camunda.service.search.result.QueryResultConfigBuilders;
import io.camunda.service.search.sort.ProcessInstanceSort;
import io.camunda.service.search.sort.SortOptionBuilders;
import io.camunda.util.ObjectBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;

public final class ProcessInstanceQuery
extends Record
implements TypedSearchQuery<ProcessInstanceFilter, ProcessInstanceSort> {
    private final ProcessInstanceFilter filter;
    private final ProcessInstanceSort sort;
    private final SearchQueryPage page;
    private final QueryResultConfig resultConfig;

    public ProcessInstanceQuery(ProcessInstanceFilter filter, ProcessInstanceSort sort, SearchQueryPage page, QueryResultConfig resultConfig) {
        this.filter = filter;
        this.sort = sort;
        this.page = page;
        this.resultConfig = resultConfig;
    }

    public static ProcessInstanceQuery of(Function<Builder, ObjectBuilder<ProcessInstanceQuery>> fn) {
        return (ProcessInstanceQuery)fn.apply(new Builder()).build();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProcessInstanceQuery.class, "filter;sort;page;resultConfig", "filter", "sort", "page", "resultConfig"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProcessInstanceQuery.class, "filter;sort;page;resultConfig", "filter", "sort", "page", "resultConfig"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProcessInstanceQuery.class, "filter;sort;page;resultConfig", "filter", "sort", "page", "resultConfig"}, this, o);
    }

    @Override
    public ProcessInstanceFilter filter() {
        return this.filter;
    }

    @Override
    public ProcessInstanceSort sort() {
        return this.sort;
    }

    @Override
    public SearchQueryPage page() {
        return this.page;
    }

    @Override
    public QueryResultConfig resultConfig() {
        return this.resultConfig;
    }

    public static final class Builder
    extends SearchQueryBase.AbstractQueryBuilder<Builder>
    implements TypedSearchQueryBuilder<ProcessInstanceQuery, Builder, ProcessInstanceFilter, ProcessInstanceSort> {
        private static final ProcessInstanceFilter EMPTY_FILTER = FilterBuilders.processInstance().build();
        private static final ProcessInstanceSort EMPTY_SORT = SortOptionBuilders.processInstance().build();
        private ProcessInstanceFilter filter;
        private ProcessInstanceSort sort;
        private ProcessInstanceQueryResultConfig resultConfig;

        @Override
        public Builder filter(ProcessInstanceFilter value) {
            this.filter = value;
            return this;
        }

        @Override
        public Builder filter(Function<ProcessInstanceFilter.Builder, ObjectBuilder<ProcessInstanceFilter>> fn) {
            return this.filter(FilterBuilders.processInstance(fn));
        }

        @Override
        public Builder sort(ProcessInstanceSort value) {
            this.sort = value;
            return this;
        }

        @Override
        public Builder sort(Function<ProcessInstanceSort.Builder, ObjectBuilder<ProcessInstanceSort>> fn) {
            return this.sort(SortOptionBuilders.processInstance(fn));
        }

        public Builder resultConfig(ProcessInstanceQueryResultConfig value) {
            this.resultConfig = value;
            return this;
        }

        public Builder resultConfig(Function<ProcessInstanceQueryResultConfig.Builder, ObjectBuilder<ProcessInstanceQueryResultConfig>> fn) {
            return this.resultConfig(QueryResultConfigBuilders.processInstance(fn));
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ProcessInstanceQuery build() {
            this.filter = Objects.requireNonNullElse(this.filter, EMPTY_FILTER);
            this.sort = Objects.requireNonNullElse(this.sort, EMPTY_SORT);
            return new ProcessInstanceQuery(this.filter, this.sort, this.page(), this.resultConfig);
        }
    }
}

