/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.query;

import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.filter.UserTaskFilter;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.SearchQueryBase;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.query.TypedSearchQueryBuilder;
import io.camunda.service.search.sort.SortOptionBuilders;
import io.camunda.service.search.sort.UserTaskSort;
import io.camunda.util.ObjectBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;

public final class UserTaskQuery
extends Record
implements TypedSearchQuery<UserTaskFilter, UserTaskSort> {
    private final UserTaskFilter filter;
    private final UserTaskSort sort;
    private final SearchQueryPage page;

    public UserTaskQuery(UserTaskFilter filter, UserTaskSort sort, SearchQueryPage page) {
        this.filter = filter;
        this.sort = sort;
        this.page = page;
    }

    public static UserTaskQuery of(Function<Builder, ObjectBuilder<UserTaskQuery>> fn) {
        return (UserTaskQuery)fn.apply(new Builder()).build();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{UserTaskQuery.class, "filter;sort;page", "filter", "sort", "page"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UserTaskQuery.class, "filter;sort;page", "filter", "sort", "page"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UserTaskQuery.class, "filter;sort;page", "filter", "sort", "page"}, this, o);
    }

    @Override
    public UserTaskFilter filter() {
        return this.filter;
    }

    @Override
    public UserTaskSort sort() {
        return this.sort;
    }

    @Override
    public SearchQueryPage page() {
        return this.page;
    }

    public static final class Builder
    extends SearchQueryBase.AbstractQueryBuilder<Builder>
    implements TypedSearchQueryBuilder<UserTaskQuery, Builder, UserTaskFilter, UserTaskSort> {
        private static final UserTaskFilter EMPTY_FILTER = FilterBuilders.userTask().build();
        private static final UserTaskSort EMPTY_SORT = SortOptionBuilders.userTask().build();
        private UserTaskFilter filter;
        private UserTaskSort sort;

        @Override
        public Builder filter(UserTaskFilter value) {
            this.filter = value;
            return this;
        }

        @Override
        public Builder sort(UserTaskSort value) {
            this.sort = value;
            return this;
        }

        @Override
        public Builder filter(Function<UserTaskFilter.Builder, ObjectBuilder<UserTaskFilter>> fn) {
            return this.filter(FilterBuilders.userTask(fn));
        }

        @Override
        public Builder sort(Function<UserTaskSort.Builder, ObjectBuilder<UserTaskSort>> fn) {
            return this.sort(SortOptionBuilders.userTask(fn));
        }

        @Override
        protected Builder self() {
            return this;
        }

        public UserTaskQuery build() {
            this.filter = Objects.requireNonNullElse(this.filter, EMPTY_FILTER);
            this.sort = Objects.requireNonNullElse(this.sort, EMPTY_SORT);
            return new UserTaskQuery(this.filter, this.sort, this.page());
        }
    }
}

