/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.security.auth;

import io.camunda.service.search.filter.FilterBase;
import io.camunda.util.CollectionUtil;
import io.camunda.util.ObjectBuilder;
import java.util.List;

public record Authentication(String authenticatedUserId, List<String> authenticatedGroupIds, List<String> authenticatedTenantIds, String token) implements FilterBase
{

    public static final class Builder
    implements ObjectBuilder<Authentication> {
        private String user;
        private List<String> groups;
        private List<String> tenants;
        private String token;

        public Builder user(String value) {
            this.user = value;
            return this;
        }

        public Builder group(String value) {
            return this.groups(List.of(value));
        }

        public Builder groups(List<String> values) {
            this.groups = CollectionUtil.addValuesToList(this.groups, values);
            return this;
        }

        public Builder tenant(String tenant) {
            return this.tenants(List.of(tenant));
        }

        public Builder tenants(List<String> values) {
            this.tenants = CollectionUtil.addValuesToList(this.tenants, values);
            return this;
        }

        public Builder token(String value) {
            this.token = value;
            return this;
        }

        public Authentication build() {
            return new Authentication(this.user, this.groups, this.tenants, this.token);
        }
    }
}

