/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.service.search.filter.ComparableValueFilter;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.Collections;

public class ComparableValueFilterTransformer
implements FilterTransformer<ComparableFieldFilter> {
    @Override
    public SearchQuery toSearchQuery(ComparableFieldFilter filter) {
        SearchQuery valueQuery;
        String field = filter.field();
        ComparableValueFilter filterParams = filter.filter();
        if (filterParams.eq() != null) {
            valueQuery = SearchQueryBuilders.bool().must(Collections.singletonList(this.of(filterParams.eq(), field))).build().toSearchQuery();
        } else if (filterParams.neq() != null) {
            valueQuery = SearchQueryBuilders.not((SearchQuery)this.of(filterParams.neq(), field), (SearchQuery[])new SearchQuery[0]);
        } else {
            SearchRangeQuery.Builder builder = SearchQueryBuilders.range().field(field);
            if (filterParams.gt() != null) {
                builder.gt(filterParams.gt());
            }
            if (filterParams.gte() != null) {
                builder.gte(filterParams.gte());
            }
            if (filterParams.lt() != null) {
                builder.lt(filterParams.lt());
            }
            if (filterParams.lte() != null) {
                builder.lte(filterParams.lte());
            }
            valueQuery = builder.build().toSearchQuery();
        }
        return valueQuery;
    }

    private SearchQuery of(Object value, String field) {
        TypedValue typedValue = TypedValue.toTypedValue((Object)value);
        return SearchQueryBuilders.term().field(field).value(typedValue).build().toSearchQuery();
    }

    public record ComparableFieldFilter(String field, ComparableValueFilter filter) implements FilterBase
    {
    }
}

