/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.service.entities.DecisionInstanceEntity;
import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.DecisionInstanceFilter;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.DateValueFilterTransformer;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.List;

public final class DecisionInstanceFilterTransformer
implements FilterTransformer<DecisionInstanceFilter> {
    private final ServiceTransformers transformers;

    public DecisionInstanceFilterTransformer(ServiceTransformers transformers) {
        this.transformers = transformers;
    }

    @Override
    public SearchQuery toSearchQuery(DecisionInstanceFilter filter) {
        SearchQuery keysQuery = this.getKeysQuery(filter.keys());
        SearchQuery statesQuery = this.getStatesQuery(filter.states());
        SearchQuery evaluationDateQuery = this.getEvaluationDateQuery(filter.evaluationDate());
        SearchQuery evaluationFailuresQuery = this.getEvaluationFailuresQuery(filter.evaluationFailures());
        SearchQuery processDefinitionKeysQuery = this.getProcessDefinitionKeysQuery(filter.processDefinitionKeys());
        SearchQuery processInstanceKeysQuery = this.getProcessInstanceKeysQuery(filter.processInstanceKeys());
        SearchQuery decisionKeysQuery = this.getDecisionKeysQuery(filter.decisionKeys());
        SearchQuery dmnDecisionIdsQuery = this.getDmnDecisionIdsQuery(filter.dmnDecisionIds());
        SearchQuery dmnDecisionNamesQuery = this.getDmnDecisionNamesQuery(filter.dmnDecisionNames());
        SearchQuery decisionVersionsQuery = this.getDecisionVersionsQuery(filter.decisionVersions());
        SearchQuery decisionTypesQuery = this.getDecisionTypesQuery(filter.decisionTypes());
        SearchQuery tenantIdsQuery = this.getTenantIdsQuery(filter.tenantIds());
        return SearchQueryBuilders.and((SearchQuery)keysQuery, (SearchQuery[])new SearchQuery[]{statesQuery, evaluationDateQuery, evaluationFailuresQuery, processDefinitionKeysQuery, processInstanceKeysQuery, decisionKeysQuery, dmnDecisionIdsQuery, dmnDecisionNamesQuery, decisionVersionsQuery, decisionTypesQuery, tenantIdsQuery});
    }

    @Override
    public List<String> toIndices(DecisionInstanceFilter filter) {
        return List.of("operate-decision-instance-8.3.0_alias");
    }

    private SearchQuery getKeysQuery(List<Long> keys) {
        return SearchQueryBuilders.longTerms((String)"key", keys);
    }

    private SearchQuery getStatesQuery(List<DecisionInstanceEntity.DecisionInstanceState> states) {
        return SearchQueryBuilders.stringTerms((String)"state", states != null ? states.stream().map(Enum::name).toList() : null);
    }

    private SearchQuery getEvaluationDateQuery(DateValueFilter filter) {
        if (filter != null) {
            FilterTransformer transformer = this.transformers.getFilterTransformer(DateValueFilter.class);
            return transformer.apply(new DateValueFilterTransformer.DateFieldFilter("evaluationDate", filter));
        }
        return null;
    }

    private SearchQuery getEvaluationFailuresQuery(List<String> evaluationFailures) {
        return SearchQueryBuilders.stringTerms((String)"evaluationFailure", evaluationFailures);
    }

    private SearchQuery getProcessDefinitionKeysQuery(List<Long> processDefinitionKeys) {
        return SearchQueryBuilders.longTerms((String)"processDefinitionKey", processDefinitionKeys);
    }

    private SearchQuery getProcessInstanceKeysQuery(List<Long> processInstanceKeys) {
        return SearchQueryBuilders.longTerms((String)"processInstanceKey", processInstanceKeys);
    }

    private SearchQuery getDecisionKeysQuery(List<Long> decisionKeys) {
        return SearchQueryBuilders.stringTerms((String)"decisionDefinitionId", decisionKeys != null ? decisionKeys.stream().map(String::valueOf).toList() : null);
    }

    private SearchQuery getDmnDecisionIdsQuery(List<String> dmnDecisionIds) {
        return SearchQueryBuilders.stringTerms((String)"decisionId", dmnDecisionIds);
    }

    private SearchQuery getDmnDecisionNamesQuery(List<String> dmnDecisionNames) {
        return SearchQueryBuilders.stringTerms((String)"decisionName", dmnDecisionNames);
    }

    private SearchQuery getDecisionVersionsQuery(List<Integer> decisionVersions) {
        return SearchQueryBuilders.intTerms((String)"decisionVersion", decisionVersions);
    }

    private SearchQuery getDecisionTypesQuery(List<DecisionInstanceEntity.DecisionInstanceType> decisionTypes) {
        return SearchQueryBuilders.stringTerms((String)"decisionType", decisionTypes != null ? decisionTypes.stream().map(Enum::name).toList() : null);
    }

    private SearchQuery getTenantIdsQuery(List<String> tenantIds) {
        return SearchQueryBuilders.stringTerms((String)"tenantId", tenantIds);
    }
}

