/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.service.search.filter.DecisionRequirementsFilter;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.List;

public final class DecisionRequirementsFilterTransformer
implements FilterTransformer<DecisionRequirementsFilter> {
    @Override
    public SearchQuery toSearchQuery(DecisionRequirementsFilter filter) {
        SearchQuery keysQuery = this.getKeysQuery(filter.decisionRequirementsKeys());
        SearchQuery namesQuery = this.getNamesQuery(filter.dmnDecisionRequirementsNames());
        SearchQuery versionsQuery = this.getVersionsQuery(filter.versions());
        SearchQuery decisionRequirementsIdsQuery = this.getDecisionRequirementsIdsQuery(filter.decisionRequirementsIds());
        SearchQuery tenantIdsQuery = this.getTenantIdsQuery(filter.tenantIds());
        return SearchQueryBuilders.and((SearchQuery)keysQuery, (SearchQuery[])new SearchQuery[]{namesQuery, versionsQuery, decisionRequirementsIdsQuery, tenantIdsQuery});
    }

    @Override
    public List<String> toIndices(DecisionRequirementsFilter filter) {
        return List.of("operate-decision-requirements-8.3.0_alias");
    }

    private SearchQuery getKeysQuery(List<Long> keys) {
        return SearchQueryBuilders.longTerms((String)"key", keys);
    }

    private SearchQuery getNamesQuery(List<String> names) {
        return SearchQueryBuilders.stringTerms((String)"name", names);
    }

    private SearchQuery getVersionsQuery(List<Integer> versions) {
        return SearchQueryBuilders.intTerms((String)"version", versions);
    }

    private SearchQuery getDecisionRequirementsIdsQuery(List<String> decisionRequirementsIds) {
        return SearchQueryBuilders.stringTerms((String)"decisionRequirementsId", decisionRequirementsIds);
    }

    private SearchQuery getTenantIdsQuery(List<String> tenantIds) {
        return SearchQueryBuilders.stringTerms((String)"tenantId", tenantIds);
    }
}

