/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.service.search.filter.UserTaskFilter;
import io.camunda.service.search.filter.VariableValueFilter;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class UserTaskFilterTransformer
implements FilterTransformer<UserTaskFilter> {
    private final ServiceTransformers transformers;

    public UserTaskFilterTransformer(ServiceTransformers transformers) {
        this.transformers = transformers;
    }

    @Override
    public SearchQuery toSearchQuery(UserTaskFilter filter) {
        SearchQuery userTaskKeysQuery = this.getUserTaskKeysQuery(filter.keys());
        SearchQuery processInstanceKeysQuery = this.getProcessInstanceKeysQuery(filter.processInstanceKeys());
        SearchQuery processDefinitionKeyQuery = this.getProcessDefinitionKeyQuery(filter.processDefinitionKeys());
        SearchQuery bpmnProcessDefinitionIdQuery = this.getBpmnProcessIdQuery(filter.bpmnProcessIds());
        SearchQuery elementIdQuery = this.getElementIdQuery(filter.elementIds());
        SearchQuery candidateUsersQuery = this.getCandidateUsersQuery(filter.candidateUsers());
        SearchQuery candidateGroupsQuery = this.getCandidateGroupsQuery(filter.candidateGroups());
        SearchQuery assigneesQuery = this.getAssigneesQuery(filter.assignees());
        SearchQuery stateQuery = this.getStateQuery(filter.states());
        SearchQuery tenantQuery = this.getTenantQuery(filter.tenantIds());
        SearchQuery taskVariableQuery = this.getTaskVariablesQuery(filter.variableFilters());
        SearchQuery processVariableQuery = this.getProcessVariablesQuery(filter.variableFilters());
        SearchQuery typeQuery = SearchQueryBuilders.exists((String)"flowNodeInstanceId");
        SearchQuery variablesQuery = null;
        if (filter.variableFilters() != null && !filter.variableFilters().isEmpty()) {
            SearchQuery taskVarNameQuery = filter.variableFilters() != null ? SearchQueryBuilders.stringTerms((String)"name", (Collection)filter.variableFilters().stream().map(VariableValueFilter::name).collect(Collectors.toList())) : null;
            SearchQuery processVariableCondition = SearchQueryBuilders.and((SearchQuery)SearchQueryBuilders.hasParentQuery((String)"process", (SearchQuery)processVariableQuery), (SearchQuery[])new SearchQuery[]{SearchQueryBuilders.not((SearchQuery)SearchQueryBuilders.hasChildQuery((String)"taskVariable", (SearchQuery)taskVarNameQuery), (SearchQuery[])new SearchQuery[0])});
            variablesQuery = SearchQueryBuilders.or((SearchQuery)taskVariableQuery, (SearchQuery[])new SearchQuery[]{processVariableCondition});
        }
        return SearchQueryBuilders.and((SearchQuery)userTaskKeysQuery, (SearchQuery[])new SearchQuery[]{bpmnProcessDefinitionIdQuery, candidateUsersQuery, candidateGroupsQuery, assigneesQuery, stateQuery, processInstanceKeysQuery, processDefinitionKeyQuery, tenantQuery, elementIdQuery, variablesQuery, typeQuery});
    }

    @Override
    public List<String> toIndices(UserTaskFilter filter) {
        return Arrays.asList("tasklist-list-view-8.6.0_");
    }

    private SearchQuery getProcessInstanceKeysQuery(List<Long> processInstanceKeys) {
        return SearchQueryBuilders.longTerms((String)"processInstanceId", processInstanceKeys);
    }

    private SearchQuery getProcessDefinitionKeyQuery(List<Long> processDefinitionIds) {
        return SearchQueryBuilders.longTerms((String)"processDefinitionId", processDefinitionIds);
    }

    private SearchQuery getUserTaskKeysQuery(List<Long> userTaskKeys) {
        return SearchQueryBuilders.longTerms((String)"key", userTaskKeys);
    }

    private SearchQuery getCandidateUsersQuery(List<String> candidateUsers) {
        return SearchQueryBuilders.stringTerms((String)"candidateUsers", candidateUsers);
    }

    private SearchQuery getCandidateGroupsQuery(List<String> candidateGroups) {
        return SearchQueryBuilders.stringTerms((String)"candidateGroups", candidateGroups);
    }

    private SearchQuery getAssigneesQuery(List<String> assignee) {
        return SearchQueryBuilders.stringTerms((String)"assignee", assignee);
    }

    private SearchQuery getStateQuery(List<String> state) {
        return SearchQueryBuilders.stringTerms((String)"state", state);
    }

    private SearchQuery getTenantQuery(List<String> tenant) {
        return SearchQueryBuilders.stringTerms((String)"tenantId", tenant);
    }

    private SearchQuery getBpmnProcessIdQuery(List<String> bpmnProcessId) {
        return SearchQueryBuilders.stringTerms((String)"bpmnProcessId", bpmnProcessId);
    }

    private SearchQuery getElementIdQuery(List<String> taskDefinitionId) {
        return SearchQueryBuilders.stringTerms((String)"flowNodeBpmnId", taskDefinitionId);
    }

    private SearchQuery getProcessVariablesQuery(List<VariableValueFilter> variableFilters) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            FilterTransformer<VariableValueFilter> transformer = this.getVariableValueFilterTransformer();
            List queries = variableFilters.stream().map(transformer::apply).map(q -> SearchQueryBuilders.hasChildQuery((String)"processVariable", (SearchQuery)q)).collect(Collectors.toList());
            return SearchQueryBuilders.or(queries);
        }
        return null;
    }

    private SearchQuery getTaskVariablesQuery(List<VariableValueFilter> variableFilters) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            FilterTransformer<VariableValueFilter> transformer = this.getVariableValueFilterTransformer();
            List queries = variableFilters.stream().map(transformer::apply).map(q -> SearchQueryBuilders.hasChildQuery((String)"taskVariable", (SearchQuery)q)).collect(Collectors.toList());
            return SearchQueryBuilders.or(queries);
        }
        return null;
    }

    private FilterTransformer<VariableValueFilter> getVariableValueFilterTransformer() {
        return this.transformers.getFilterTransformer(VariableValueFilter.class);
    }
}

