/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.service.search.filter.VariableFilter;
import io.camunda.service.search.filter.VariableValueFilter;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.FilterTransformer;
import io.camunda.service.transformers.filter.VariableValueFilterTransformer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class VariableFilterTransformer
implements FilterTransformer<VariableFilter> {
    private final ServiceTransformers transformers;
    private final VariableValueFilterTransformer variableValueFilterTransformer;

    public VariableFilterTransformer(ServiceTransformers transformers, VariableValueFilterTransformer variableValueFilterTransformer) {
        this.transformers = transformers;
        this.variableValueFilterTransformer = variableValueFilterTransformer;
    }

    @Override
    public SearchQuery toSearchQuery(VariableFilter filter) {
        SearchQuery variablesQuery = this.getVariablesQuery(filter.variableFilters(), filter.orConditions());
        SearchQuery scopeKeyQuery = this.getScopeKeyQuery(filter.scopeKeys());
        SearchQuery processInstanceKeyQuery = this.getProcessInstanceKeyQuery(filter.processInstanceKeys());
        return SearchQueryBuilders.and((SearchQuery)variablesQuery, (SearchQuery[])new SearchQuery[]{scopeKeyQuery, processInstanceKeyQuery});
    }

    @Override
    public List<String> toIndices(VariableFilter filter) {
        boolean onlyRuntimeVariables = filter.onlyRuntimeVariables();
        if (onlyRuntimeVariables) {
            return Arrays.asList("operate-variable-8.3.0_");
        }
        return Arrays.asList("operate-variable-8.3.0_alias");
    }

    private SearchQuery getVariablesQuery(List<VariableValueFilter> variableFilters, boolean orConditions) {
        if (variableFilters != null && !variableFilters.isEmpty()) {
            List queries = variableFilters.stream().map(v -> this.variableValueFilterTransformer.toSearchQuery((VariableValueFilter)v, "name", "value")).collect(Collectors.toList());
            return orConditions ? SearchQueryBuilders.or(queries) : SearchQueryBuilders.and(queries);
        }
        return null;
    }

    private SearchQuery of(Object value) {
        TypedValue typedValue = TypedValue.toTypedValue((Object)value);
        return SearchQueryBuilders.term().field("value").value(typedValue).build().toSearchQuery();
    }

    private SearchQuery getScopeKeyQuery(List<Long> scopeKey) {
        return SearchQueryBuilders.longTerms((String)"scopeKey", scopeKey);
    }

    private SearchQuery getProcessInstanceKeyQuery(List<Long> processInstanceKey) {
        return SearchQueryBuilders.longTerms((String)"processInstanceKey", processInstanceKey);
    }
}

