/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.search.clients.types.TypedValue;
import io.camunda.service.search.filter.VariableValueFilter;
import io.camunda.service.transformers.filter.FilterTransformer;

public final class VariableValueFilterTransformer
implements FilterTransformer<VariableValueFilter> {
    @Override
    public SearchQuery toSearchQuery(VariableValueFilter value) {
        return this.toSearchQuery(value, "name", "value");
    }

    public SearchQuery toSearchQuery(VariableValueFilter value, String varName, String varValue) {
        SearchQuery variableValueQuery;
        String name = value.name();
        Object eq = value.eq();
        Object neq = value.neq();
        Object gt = value.gt();
        Object gte = value.gte();
        Object lt = value.lt();
        Object lte = value.lte();
        SearchQuery variableNameQuery = SearchQueryBuilders.term((String)varName, (String)name);
        if (eq != null) {
            variableValueQuery = this.of(eq, varValue);
        } else if (neq != null) {
            variableValueQuery = SearchQueryBuilders.not((SearchQuery)this.of(neq, varValue), (SearchQuery[])new SearchQuery[0]);
        } else {
            SearchRangeQuery.Builder builder = SearchQueryBuilders.range().field(varValue);
            if (gt != null) {
                builder.gt(gt);
            }
            if (gte != null) {
                builder.gte(gte);
            }
            if (lt != null) {
                builder.lt(lt);
            }
            if (lte != null) {
                builder.lte(lte);
            }
            variableValueQuery = builder.build().toSearchQuery();
        }
        return SearchQueryBuilders.and((SearchQuery)variableNameQuery, (SearchQuery[])new SearchQuery[]{variableValueQuery});
    }

    private SearchQuery of(Object value, String field) {
        TypedValue typedValue = TypedValue.toTypedValue((Object)value);
        return SearchQueryBuilders.term().field(field).value(typedValue).build().toSearchQuery();
    }
}

