/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.query;

import io.camunda.search.clients.core.SearchQueryHit;
import io.camunda.search.clients.core.SearchQueryResponse;
import io.camunda.service.search.query.SearchQueryResult;
import io.camunda.service.transformers.ServiceTransformer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class SearchQueryResultTransformer<T>
implements ServiceTransformer<SearchQueryResponse<T>, SearchQueryResult<T>> {
    @Override
    public SearchQueryResult<T> apply(SearchQueryResponse<T> value) {
        Object[] sortValues;
        List hits = value.hits();
        List<T> items = this.of(hits);
        int size = hits.size();
        if (size > 0) {
            SearchQueryHit lastItem = (SearchQueryHit)hits.get(size - 1);
            sortValues = lastItem.sortValues();
        } else {
            sortValues = null;
        }
        return new SearchQueryResult.Builder().total(value.totalHits()).sortValues(sortValues).items(items).build();
    }

    private List<T> of(List<SearchQueryHit<T>> values) {
        if (values != null) {
            return values.stream().map(SearchQueryHit::source).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

