/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.result;

import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.search.clients.source.SearchSourceFilter;
import io.camunda.service.search.result.QueryResultConfig;
import io.camunda.service.transformers.ServiceTransformer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ResultConfigTransformer
implements ServiceTransformer<QueryResultConfig, SearchSourceConfig> {
    @Override
    public SearchSourceConfig apply(QueryResultConfig value) {
        if (value != null) {
            SearchSourceConfig.Builder builder = new SearchSourceConfig.Builder();
            List<QueryResultConfig.FieldFilter> fieldFilters = value.getFieldFilters();
            if (fieldFilters != null && !fieldFilters.isEmpty()) {
                builder.filter(this.toSearchSourceFilter(fieldFilters));
            }
            return builder.build();
        }
        return null;
    }

    private SearchSourceFilter toSearchSourceFilter(List<QueryResultConfig.FieldFilter> value) {
        Map includedVsExcludedMap = value.stream().collect(Collectors.partitioningBy(QueryResultConfig.FieldFilter::include, Collectors.mapping(QueryResultConfig.FieldFilter::field, Collectors.toList())));
        return new SearchSourceFilter.Builder().includes(includedVsExcludedMap.get(true)).excludes(includedVsExcludedMap.get(false)).build();
    }
}

