/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.annotation;

import io.camunda.client.annotation.CustomHeaders;
import io.camunda.client.annotation.Deployment;
import io.camunda.client.annotation.Document;
import io.camunda.client.annotation.JobWorker;
import io.camunda.client.annotation.Variable;
import io.camunda.client.annotation.VariablesAsType;
import io.camunda.client.annotation.value.DeploymentValue;
import io.camunda.client.annotation.value.DocumentValue;
import io.camunda.client.annotation.value.JobWorkerValue;
import io.camunda.client.annotation.value.VariableValue;
import io.camunda.client.api.response.DocumentReferenceResponse;
import io.camunda.client.bean.BeanInfo;
import io.camunda.client.bean.MethodInfo;
import io.camunda.client.bean.ParameterInfo;
import io.camunda.client.jobhandling.DocumentContext;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationUtil.class);
    private static final Map<String, DocumentValue.ParameterType> DOCUMENT_PARAMETER_TYPES = Map.of(List.class.getName() + "<" + DocumentReferenceResponse.class.getName() + ">", DocumentValue.ParameterType.LIST, DocumentReferenceResponse.class.getName(), DocumentValue.ParameterType.SINGLE, DocumentContext.class.getName(), DocumentValue.ParameterType.CONTEXT);

    public static boolean isVariable(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(Variable.class) || AnnotationUtil.isVariableLegacy(parameterInfo);
    }

    public static boolean isDocument(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(Document.class) && DOCUMENT_PARAMETER_TYPES.containsKey(parameterInfo.getParameter().getParameterizedType().getTypeName());
    }

    public static List<ParameterInfo> getVariableParameters(MethodInfo methodInfo) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        result.addAll(methodInfo.getParametersFilteredByAnnotation(Variable.class));
        result.addAll(methodInfo.getParametersFilteredByAnnotation(io.camunda.zeebe.spring.client.annotation.Variable.class));
        return result;
    }

    public static List<ParameterInfo> getVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        result.addAll(methodInfo.getParametersFilteredByAnnotation(VariablesAsType.class));
        result.addAll(methodInfo.getParametersFilteredByAnnotation(io.camunda.zeebe.spring.client.annotation.VariablesAsType.class));
        return result;
    }

    public static boolean isVariablesAsType(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(VariablesAsType.class) || AnnotationUtil.isVariablesAsTypeLegacy(parameterInfo);
    }

    public static boolean isCustomHeaders(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(CustomHeaders.class) || AnnotationUtil.isCustomHeadersLegacy(parameterInfo);
    }

    public static boolean isDeployment(BeanInfo beanInfo) {
        return beanInfo.hasClassAnnotation(Deployment.class) || AnnotationUtil.isDeploymentLegacy(beanInfo);
    }

    public static boolean isJobWorker(BeanInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(JobWorker.class) || AnnotationUtil.isJobWorkerLegacy(beanInfo);
    }

    private static boolean isJobWorkerLegacy(BeanInfo beanInfo) {
        return beanInfo.hasMethodAnnotation(io.camunda.zeebe.spring.client.annotation.JobWorker.class);
    }

    public static Optional<JobWorkerValue> getJobWorkerValue(MethodInfo methodInfo) {
        return AnnotationUtil.getJobWorkerValueInternal(methodInfo).or(() -> AnnotationUtil.getJobWorkerValueLegacyInternal(methodInfo));
    }

    private static Optional<JobWorkerValue> getJobWorkerValueInternal(MethodInfo methodInfo) {
        Optional<JobWorker> methodAnnotation = methodInfo.getAnnotation(JobWorker.class);
        if (methodAnnotation.isPresent()) {
            JobWorker annotation = methodAnnotation.get();
            return Optional.of(new JobWorkerValue(annotation.type(), annotation.name(), Duration.of(annotation.timeout(), ChronoUnit.MILLIS), annotation.maxJobsActive(), Duration.of(annotation.requestTimeout(), ChronoUnit.SECONDS), Duration.of(annotation.pollInterval(), ChronoUnit.MILLIS), annotation.autoComplete(), Arrays.asList(annotation.fetchVariables()), annotation.enabled(), methodInfo, Arrays.asList(annotation.tenantIds()), annotation.fetchAllVariables(), annotation.streamEnabled(), Duration.of(annotation.streamTimeout(), ChronoUnit.MILLIS), annotation.maxRetries()));
        }
        return Optional.empty();
    }

    private static Optional<JobWorkerValue> getJobWorkerValueLegacyInternal(MethodInfo methodInfo) {
        Optional<io.camunda.zeebe.spring.client.annotation.JobWorker> methodAnnotation = methodInfo.getAnnotation(io.camunda.zeebe.spring.client.annotation.JobWorker.class);
        if (methodAnnotation.isPresent()) {
            io.camunda.zeebe.spring.client.annotation.JobWorker annotation = methodAnnotation.get();
            return Optional.of(new JobWorkerValue(annotation.type(), annotation.name(), Duration.of(annotation.timeout(), ChronoUnit.MILLIS), annotation.maxJobsActive(), Duration.of(annotation.requestTimeout(), ChronoUnit.SECONDS), Duration.of(annotation.pollInterval(), ChronoUnit.MILLIS), annotation.autoComplete(), Arrays.asList(annotation.fetchVariables()), annotation.enabled(), methodInfo, Arrays.asList(annotation.tenantIds()), annotation.fetchAllVariables(), annotation.streamEnabled(), Duration.of(annotation.streamTimeout(), ChronoUnit.MILLIS), annotation.maxRetries()));
        }
        return Optional.empty();
    }

    public static Optional<VariableValue> getVariableValue(ParameterInfo parameterInfo) {
        if (AnnotationUtil.isVariable(parameterInfo)) {
            if (!AnnotationUtil.isVariableLegacy(parameterInfo)) {
                return Optional.of(new VariableValue(AnnotationUtil.getVariableName(parameterInfo), parameterInfo, AnnotationUtil.getVariableOptional(parameterInfo)));
            }
            return Optional.of(new VariableValue(AnnotationUtil.getVariableNameLegacy(parameterInfo), parameterInfo, true));
        }
        return Optional.empty();
    }

    public static Optional<DocumentValue> getDocumentValue(ParameterInfo parameterInfo) {
        if (AnnotationUtil.isDocument(parameterInfo)) {
            return Optional.of(new DocumentValue(AnnotationUtil.getDocumentName(parameterInfo), parameterInfo, AnnotationUtil.getDocumentOptional(parameterInfo), AnnotationUtil.getDocumentParameterType(parameterInfo)));
        }
        return Optional.empty();
    }

    private static DocumentValue.ParameterType getDocumentParameterType(ParameterInfo parameterInfo) {
        return Optional.ofNullable(DOCUMENT_PARAMETER_TYPES.get(parameterInfo.getParameter().getParameterizedType().getTypeName())).orElseThrow(() -> new IllegalArgumentException("Unsupported parameter type for document: " + parameterInfo.getParameter().getParameterizedType().getTypeName()));
    }

    public static List<DeploymentValue> getDeploymentValues(BeanInfo beanInfo) {
        if (AnnotationUtil.isDeployment(beanInfo)) {
            ArrayList<DeploymentValue> values = new ArrayList<DeploymentValue>();
            values.addAll(AnnotationUtil.getDeploymentValuesInternal(beanInfo));
            values.addAll(AnnotationUtil.getDeploymentResourcesLegacy(beanInfo));
            return values;
        }
        return Collections.emptyList();
    }

    private static List<DeploymentValue> getDeploymentValuesInternal(BeanInfo beanInfo) {
        return beanInfo.getAnnotation(Deployment.class).map(AnnotationUtil::fromAnnotation).map(xva$0 -> Arrays.asList(xva$0)).orElseGet(List::of);
    }

    private static DeploymentValue fromAnnotation(Deployment deploymentAnnotation) {
        return new DeploymentValue(Arrays.asList(deploymentAnnotation.resources()), StringUtils.isEmpty((CharSequence)deploymentAnnotation.tenantId()) ? null : deploymentAnnotation.tenantId());
    }

    private static List<DeploymentValue> getDeploymentResourcesLegacy(BeanInfo beanInfo) {
        return beanInfo.getAnnotation(io.camunda.zeebe.spring.client.annotation.Deployment.class).map(AnnotationUtil::fromAnnotation).map(xva$0 -> Arrays.asList(xva$0)).orElseGet(List::of);
    }

    private static DeploymentValue fromAnnotation(io.camunda.zeebe.spring.client.annotation.Deployment deploymentAnnotation) {
        return new DeploymentValue(Arrays.asList(deploymentAnnotation.resources()), StringUtils.isEmpty((CharSequence)deploymentAnnotation.tenantId()) ? null : deploymentAnnotation.tenantId());
    }

    private static boolean isVariableLegacy(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.Variable.class);
    }

    private static boolean isVariablesAsTypeLegacy(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.VariablesAsType.class);
    }

    private static boolean isCustomHeadersLegacy(ParameterInfo parameterInfo) {
        return parameterInfo.getParameter().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.CustomHeaders.class);
    }

    public static boolean isDeploymentLegacy(BeanInfo beanInfo) {
        return beanInfo.hasClassAnnotation(io.camunda.zeebe.spring.client.annotation.Deployment.class);
    }

    private static String getVariableName(ParameterInfo param) {
        if (param.getParameter().isAnnotationPresent(Variable.class)) {
            String nameFromAnnotation = param.getParameter().getAnnotation(Variable.class).name();
            if (StringUtils.isNotBlank((CharSequence)nameFromAnnotation)) {
                LOG.trace("Extracting name {} from Variable.name", (Object)nameFromAnnotation);
                return nameFromAnnotation;
            }
            String valueFromAnnotation = param.getParameter().getAnnotation(Variable.class).value();
            if (StringUtils.isNotBlank((CharSequence)valueFromAnnotation)) {
                LOG.trace("Extracting name {} from Variable.value", (Object)valueFromAnnotation);
                return valueFromAnnotation;
            }
        }
        LOG.trace("Extracting variable name from parameter name");
        return param.getParameterName();
    }

    private static String getDocumentName(ParameterInfo param) {
        if (param.getParameter().isAnnotationPresent(Document.class)) {
            String nameFromAnnotation = param.getParameter().getAnnotation(Document.class).name();
            if (StringUtils.isNotBlank((CharSequence)nameFromAnnotation)) {
                LOG.trace("Extracting name {} from Document.name", (Object)nameFromAnnotation);
                return nameFromAnnotation;
            }
            String valueFromAnnotation = param.getParameter().getAnnotation(Document.class).value();
            if (StringUtils.isNotBlank((CharSequence)valueFromAnnotation)) {
                LOG.trace("Extracting name {} from Document.value", (Object)valueFromAnnotation);
                return valueFromAnnotation;
            }
        }
        LOG.trace("Extracting document name from parameter name");
        return param.getParameterName();
    }

    private static boolean getVariableOptional(ParameterInfo param) {
        if (param.getParameter().isAnnotationPresent(Variable.class)) {
            boolean optional = param.getParameter().getAnnotation(Variable.class).optional();
            LOG.trace("Extracting optional flag from Variable");
            return optional;
        }
        LOG.trace("No variable annotation found, defaulting to true");
        return true;
    }

    private static boolean getDocumentOptional(ParameterInfo param) {
        if (param.getParameter().isAnnotationPresent(Document.class)) {
            boolean optional = param.getParameter().getAnnotation(Document.class).optional();
            LOG.trace("Extracting optional flag from Document");
            return optional;
        }
        LOG.trace("No document annotation found, defaulting to true");
        return true;
    }

    private static String getVariableNameLegacy(ParameterInfo param) {
        if (param.getParameter().isAnnotationPresent(io.camunda.zeebe.spring.client.annotation.Variable.class)) {
            String nameFromAnnotation = param.getParameter().getAnnotation(io.camunda.zeebe.spring.client.annotation.Variable.class).name();
            if (!Objects.equals(nameFromAnnotation, "$NULL$")) {
                LOG.trace("Extracting name {} from Variable.name", (Object)nameFromAnnotation);
                return nameFromAnnotation;
            }
            String valueFromAnnotation = param.getParameter().getAnnotation(io.camunda.zeebe.spring.client.annotation.Variable.class).value();
            if (!Objects.equals(valueFromAnnotation, "$NULL$")) {
                LOG.trace("Extracting name {} from Variable.value", (Object)valueFromAnnotation);
                return valueFromAnnotation;
            }
        }
        LOG.trace("Extracting variable name from parameter name");
        return param.getParameterName();
    }
}

