/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.parameter;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.jobhandling.parameter.ParameterResolver;
import io.camunda.zeebe.client.api.response.UserTaskProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CompatActivatedJobParameterResolver
implements ParameterResolver {
    @Override
    public Object resolve(JobClient jobClient, ActivatedJob job) {
        return new ActivatedJobProxy(job);
    }

    public static class ActivatedJobProxy
    implements io.camunda.zeebe.client.api.response.ActivatedJob {
        private final ActivatedJob job;

        public ActivatedJobProxy(ActivatedJob job) {
            this.job = job;
        }

        public long getKey() {
            return this.job.getKey();
        }

        public String getType() {
            return this.job.getType();
        }

        public long getProcessInstanceKey() {
            return this.job.getProcessInstanceKey();
        }

        public String getBpmnProcessId() {
            return this.job.getBpmnProcessId();
        }

        public int getProcessDefinitionVersion() {
            return this.job.getProcessDefinitionVersion();
        }

        public long getProcessDefinitionKey() {
            return this.job.getProcessDefinitionKey();
        }

        public String getElementId() {
            return this.job.getElementId();
        }

        public long getElementInstanceKey() {
            return this.job.getElementInstanceKey();
        }

        public Map<String, String> getCustomHeaders() {
            return this.job.getCustomHeaders();
        }

        public String getWorker() {
            return this.job.getWorker();
        }

        public int getRetries() {
            return this.job.getRetries();
        }

        public long getDeadline() {
            return this.job.getDeadline();
        }

        public String getVariables() {
            return this.job.getVariables();
        }

        public Map<String, Object> getVariablesAsMap() {
            return this.job.getVariablesAsMap();
        }

        public <T> T getVariablesAsType(Class<T> variableType) {
            return (T)this.job.getVariablesAsType(variableType);
        }

        public Object getVariable(String name) {
            return this.job.getVariable(name);
        }

        public UserTaskProperties getUserTask() {
            if (this.job.getUserTask() == null) {
                return null;
            }
            return new UserTaskProperties(){

                public String getAction() {
                    return job.getUserTask().getAction();
                }

                public String getAssignee() {
                    return job.getUserTask().getAssignee();
                }

                public List<String> getCandidateGroups() {
                    return job.getUserTask().getCandidateGroups();
                }

                public List<String> getCandidateUsers() {
                    return job.getUserTask().getCandidateUsers();
                }

                public List<String> getChangedAttributes() {
                    return job.getUserTask().getChangedAttributes();
                }

                public String getDueDate() {
                    return Optional.ofNullable(job.getUserTask().getDueDate()).map(OffsetDateTime::toString).orElse(null);
                }

                public String getFollowUpDate() {
                    return Optional.ofNullable(job.getUserTask().getFollowUpDate()).map(OffsetDateTime::toString).orElse(null);
                }

                public Long getFormKey() {
                    return job.getUserTask().getFormKey();
                }

                public Integer getPriority() {
                    return job.getUserTask().getPriority();
                }

                public Long getUserTaskKey() {
                    return job.getUserTask().getUserTaskKey();
                }
            };
        }

        public String toJson() {
            return this.job.toJson();
        }

        public String getTenantId() {
            return this.job.getTenantId();
        }
    }
}

