/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.jobhandling.result;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.DocumentReferenceBatchResponse;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.jobhandling.DocumentContext;
import io.camunda.client.jobhandling.result.DocumentResultProcessorFailureHandlingStrategy;
import io.camunda.client.jobhandling.result.ResultDocumentContext;
import io.camunda.client.jobhandling.result.ResultProcessor;
import io.camunda.client.jobhandling.result.ResultProcessorContext;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultResultProcessor
implements ResultProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultResultProcessor.class);
    private final CamundaClient camundaClient;
    private final DocumentResultProcessorFailureHandlingStrategy exceptionHandlingStrategy;

    public DefaultResultProcessor(CamundaClient camundaClient, DocumentResultProcessorFailureHandlingStrategy exceptionHandlingStrategy) {
        this.camundaClient = camundaClient;
        this.exceptionHandlingStrategy = exceptionHandlingStrategy;
    }

    @Override
    public Object process(ResultProcessorContext context) {
        return this.handleResult(context.getResult(), context.getJob());
    }

    protected Object handleResult(Object result, ActivatedJob activatedJob) {
        if (result == null) {
            return null;
        }
        return this.handleDocuments(result, activatedJob);
    }

    protected Object handleDocuments(Object result, ActivatedJob activatedJob) {
        if (result instanceof String || result instanceof InputStream) {
            return result;
        }
        if (result instanceof Map) {
            Map resultMap = (Map)result;
            this.handleDocumentsForResultMap(resultMap, activatedJob);
            return result;
        }
        Class<?> clazz = result.getClass();
        if (this.hasDocumentField(clazz)) {
            this.handleDocumentsForResultObject(result, activatedJob);
            return result;
        }
        return result;
    }

    private boolean hasDocumentField(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).anyMatch(this::isDocumentField);
    }

    private boolean isDocumentField(Field field) {
        return this.isDocumentContext(field.getType());
    }

    private boolean isDocumentContext(Class<?> type) {
        return type.isAssignableFrom(DocumentContext.class);
    }

    private void handleDocumentsForResultObject(Object result, ActivatedJob activatedJob) {
        ReflectionUtils.doWithFields(result.getClass(), field -> {
            ReflectionUtils.makeAccessible((Field)field);
            Object fieldValue = ReflectionUtils.getField((Field)field, (Object)result);
            this.handleDocumentFieldValue(field.getName(), fieldValue, activatedJob);
        }, this::isDocumentField);
    }

    private void handleDocumentsForResultMap(Map<String, Object> result, ActivatedJob activatedJob) {
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            if (!(entry.getValue() instanceof DocumentContext)) continue;
            this.handleDocumentFieldValue(entry.getKey(), entry.getValue(), activatedJob);
        }
    }

    private void handleDocumentFieldValue(String key, Object value, ActivatedJob activatedJob) {
        if (value instanceof ResultDocumentContext) {
            ResultDocumentContext resultDocumentContext = (ResultDocumentContext)value;
            LOG.debug("Handling submitted document {}", (Object)key);
            DocumentReferenceBatchResponse response = resultDocumentContext.processDocumentBuilders(this.camundaClient);
            if (!response.isSuccessful()) {
                this.exceptionHandlingStrategy.handleFailure(new DocumentResultProcessorFailureHandlingStrategy.FailureHandlingContext(activatedJob, (JobClient)this.camundaClient, response, resultDocumentContext.getFailedDocumentBuilders()));
            }
        }
    }
}

