/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.configuration;

import io.camunda.client.CamundaClient;
import io.camunda.client.health.HealthCheck;
import io.camunda.client.metrics.MetricsRecorder;
import io.camunda.client.metrics.MicrometerMetricsRecorder;
import io.camunda.client.spring.actuator.CamundaClientHealthIndicator;
import io.camunda.client.spring.configuration.MetricsDefaultConfiguration;
import io.camunda.client.spring.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfigureBefore(value={MetricsDefaultConfiguration.class})
@ConditionalOnCamundaClientEnabled
@ConditionalOnClass(value={EndpointAutoConfiguration.class, MeterRegistry.class})
public class CamundaActuatorConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MetricsRecorder micrometerMetricsRecorder(@Lazy MeterRegistry meterRegistry) {
        return new MicrometerMetricsRecorder(meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean
    public HealthCheck camundaHealthCheck(CamundaClient client) {
        return new HealthCheck(client);
    }

    @Bean
    @ConditionalOnProperty(prefix="management.health.camunda", name={"enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnMissingBean(name={"camundaClientHealthIndicator"})
    public CamundaClientHealthIndicator camundaClientHealthIndicator(HealthCheck healthCheck) {
        return new CamundaClientHealthIndicator(healthCheck);
    }
}

