/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.configuration;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.impl.CamundaClientImpl;
import io.camunda.client.impl.util.ExecutorResource;
import io.camunda.client.jobhandling.CamundaClientExecutorService;
import io.camunda.client.spring.configuration.CamundaActuatorConfiguration;
import io.camunda.client.spring.configuration.CamundaClientAllAutoConfiguration;
import io.camunda.client.spring.configuration.CredentialsProviderConfiguration;
import io.camunda.client.spring.configuration.ExecutorServiceConfiguration;
import io.camunda.client.spring.configuration.JsonMapperConfiguration;
import io.camunda.client.spring.configuration.SpringCamundaClientConfiguration;
import io.camunda.client.spring.configuration.condition.ConditionalOnCamundaClientEnabled;
import io.camunda.client.spring.properties.CamundaClientProperties;
import io.camunda.client.spring.testsupport.CamundaSpringProcessTestContext;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnCamundaClientEnabled
@ConditionalOnMissingBean(value={CamundaSpringProcessTestContext.class})
@ImportAutoConfiguration(value={ExecutorServiceConfiguration.class, CamundaActuatorConfiguration.class, JsonMapperConfiguration.class, CredentialsProviderConfiguration.class})
@AutoConfigureBefore(value={CamundaClientAllAutoConfiguration.class})
@EnableConfigurationProperties(value={CamundaClientProperties.class})
public class CamundaClientProdAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamundaClientProdAutoConfiguration.class);

    @Bean
    public CamundaClientConfiguration camundaClientConfiguration(CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, List<AsyncExecChainHandler> chainHandlers, CamundaClientExecutorService camundaClientExecutorService, CredentialsProvider camundaClientCredentialsProvider) {
        return new SpringCamundaClientConfiguration(camundaClientProperties, jsonMapper, interceptors, chainHandlers, camundaClientExecutorService, camundaClientCredentialsProvider);
    }

    @Bean(destroyMethod="close")
    public CamundaClient camundaClient(CamundaClientConfiguration configuration) {
        LOG.debug("Creating camundaClient using {}", (Object)configuration);
        ScheduledExecutorService jobWorkerExecutor = configuration.jobWorkerExecutor();
        if (jobWorkerExecutor != null) {
            ManagedChannel managedChannel = CamundaClientImpl.buildChannel((CamundaClientConfiguration)configuration);
            GatewayGrpc.GatewayStub gatewayStub = CamundaClientImpl.buildGatewayStub((ManagedChannel)managedChannel, (CamundaClientConfiguration)configuration);
            ExecutorResource executorResource = new ExecutorResource(jobWorkerExecutor, configuration.ownsJobWorkerExecutor());
            return new CamundaClientImpl(configuration, managedChannel, gatewayStub, executorResource);
        }
        return new CamundaClientImpl(configuration);
    }
}

