/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.configuration;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.impl.NoopCredentialsProvider;
import io.camunda.client.impl.basicauth.BasicAuthCredentialsProviderBuilder;
import io.camunda.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.client.spring.properties.CamundaClientAuthProperties;
import io.camunda.client.spring.properties.CamundaClientProperties;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CredentialsProviderConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialsProviderConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public CredentialsProvider camundaClientCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        NoopCredentialsProvider noopCredentialsProvider;
        CamundaClientAuthProperties.AuthMethod authMethod = camundaClientProperties.getAuth().getMethod();
        if (authMethod == null) {
            noopCredentialsProvider = new NoopCredentialsProvider();
        } else {
            switch (authMethod) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case basic: {
                    noopCredentialsProvider = this.buildBasicAuthCredentialsProvider(camundaClientProperties);
                    break;
                }
                case oidc: {
                    noopCredentialsProvider = this.buildOAuthCredentialsProvider(camundaClientProperties);
                    break;
                }
                case none: {
                    noopCredentialsProvider = new NoopCredentialsProvider();
                }
            }
        }
        return noopCredentialsProvider;
    }

    private CredentialsProvider buildBasicAuthCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        String username = camundaClientProperties.getAuth().getUsername();
        String password = camundaClientProperties.getAuth().getPassword();
        BasicAuthCredentialsProviderBuilder builder = new BasicAuthCredentialsProviderBuilder().applyEnvironmentOverrides(false).username(username).password(password);
        try {
            return builder.build();
        }
        catch (Exception e) {
            LOG.warn("Failed to configure basic credential provider, falling back to use no authentication, cause: {}", (Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            return new NoopCredentialsProvider();
        }
    }

    private CredentialsProvider buildOAuthCredentialsProvider(CamundaClientProperties camundaClientProperties) {
        OAuthCredentialsProviderBuilder credBuilder = CredentialsProvider.newCredentialsProviderBuilder().applyEnvironmentOverrides(false).clientId(camundaClientProperties.getAuth().getClientId()).clientSecret(camundaClientProperties.getAuth().getClientSecret()).audience(camundaClientProperties.getAuth().getAudience()).scope(camundaClientProperties.getAuth().getScope()).resource(camundaClientProperties.getAuth().getResource()).authorizationServerUrl((String)Optional.ofNullable(camundaClientProperties.getAuth().getTokenUrl()).map(URI::toString).orElse(null)).credentialsCachePath(camundaClientProperties.getAuth().getCredentialsCachePath()).connectTimeout(camundaClientProperties.getAuth().getConnectTimeout()).readTimeout(camundaClientProperties.getAuth().getReadTimeout()).clientAssertionKeystorePath(camundaClientProperties.getAuth().getClientAssertion().getKeystorePath()).clientAssertionKeystorePassword(camundaClientProperties.getAuth().getClientAssertion().getKeystorePassword()).clientAssertionKeystoreKeyAlias(camundaClientProperties.getAuth().getClientAssertion().getKeystoreKeyAlias()).clientAssertionKeystoreKeyPassword(camundaClientProperties.getAuth().getClientAssertion().getKeystoreKeyPassword());
        this.maybeConfigureIdentityProviderSSLConfig(credBuilder, camundaClientProperties);
        try {
            return credBuilder.build();
        }
        catch (Exception e) {
            LOG.warn("Failed to configure oidc credential provider, falling back to use no authentication, cause: {}", (Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            return new NoopCredentialsProvider();
        }
    }

    private void maybeConfigureIdentityProviderSSLConfig(OAuthCredentialsProviderBuilder builder, CamundaClientProperties camundaClientProperties) {
        if (camundaClientProperties.getAuth().getKeystorePath() != null) {
            Path keyStore = camundaClientProperties.getAuth().getKeystorePath();
            if (Files.exists(keyStore, new LinkOption[0])) {
                LOG.debug("Using keystore {}", (Object)keyStore);
                builder.keystorePath(keyStore);
                builder.keystorePassword(camundaClientProperties.getAuth().getKeystorePassword());
                builder.keystoreKeyPassword(camundaClientProperties.getAuth().getKeystoreKeyPassword());
            } else {
                LOG.debug("Keystore {} not found", (Object)keyStore);
            }
        }
        if (camundaClientProperties.getAuth().getTruststorePath() != null) {
            Path trustStore = camundaClientProperties.getAuth().getTruststorePath();
            if (Files.exists(trustStore, new LinkOption[0])) {
                LOG.debug("Using truststore {}", (Object)trustStore);
                builder.truststorePath(trustStore);
                builder.truststorePassword(camundaClientProperties.getAuth().getTruststorePassword());
            } else {
                LOG.debug("Truststore {} not found", (Object)trustStore);
            }
        }
    }
}

