/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.spring.configuration;

import io.camunda.client.jobhandling.CamundaClientExecutorService;
import io.camunda.client.spring.properties.CamundaClientProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={MeterRegistry.class})
@ConditionalOnMissingBean(value={CamundaClientExecutorService.class})
public class ExecutorServiceConfiguration {
    private final CamundaClientProperties camundaClientProperties;

    public ExecutorServiceConfiguration(CamundaClientProperties camundaClientProperties) {
        this.camundaClientProperties = camundaClientProperties;
    }

    @Bean
    public CamundaClientExecutorService camundaClientThreadPool(@Autowired(required=false) MeterRegistry meterRegistry) {
        int executionThreads = this.camundaClientProperties.getExecutionThreads();
        ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(executionThreads);
        if (meterRegistry != null) {
            ExecutorServiceMetrics threadPoolMetrics = new ExecutorServiceMetrics((ExecutorService)threadPool, "camundaClientExecutor", Collections.singleton(Tag.of((String)"name", (String)"zeebe_client_thread_pool")));
            threadPoolMetrics.bindTo(meterRegistry);
        }
        return new CamundaClientExecutorService(threadPool, true);
    }
}

